/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.graphic.AddStyle;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HtmlColor;

public class CommandCreoleStyle
implements Command {
    private final Pattern p;
    private final FontStyle style;
    private final boolean tryExtendedColor;

    public static CommandCreoleStyle createCreole(FontStyle fontStyle) {
        return new CommandCreoleStyle("^(" + fontStyle.getCreoleSyntax() + "(.+?)" + fontStyle.getCreoleSyntax() + ")", fontStyle, false);
    }

    public static Command createLegacy(FontStyle fontStyle) {
        return new CommandCreoleStyle("^((" + fontStyle.getActivationPattern() + ")(.+?)" + fontStyle.getDeactivationPattern() + ")", fontStyle, fontStyle.canHaveExtendedColor());
    }

    public static Command createLegacyEol(FontStyle fontStyle) {
        return new CommandCreoleStyle("^((" + fontStyle.getActivationPattern() + ")(.+))$", fontStyle, fontStyle.canHaveExtendedColor());
    }

    private CommandCreoleStyle(String string, FontStyle fontStyle, boolean bl) {
        this.p = MyPattern.cmpile(string);
        this.style = fontStyle;
        this.tryExtendedColor = bl;
    }

    private HtmlColor getExtendedColor(Matcher matcher) {
        if (this.tryExtendedColor) {
            return this.style.getExtendedColor(matcher.group(2));
        }
        return null;
    }

    @Override
    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        Matcher matcher = this.p.matcher(string);
        if (!matcher.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fontConfiguration = stripeSimple.getActualFontConfiguration();
        FontConfiguration fontConfiguration2 = new AddStyle(this.style, this.getExtendedColor(matcher)).apply(fontConfiguration);
        stripeSimple.setActualFontConfiguration(fontConfiguration2);
        int n = matcher.groupCount();
        stripeSimple.analyzeAndAdd(matcher.group(n));
        stripeSimple.setActualFontConfiguration(fontConfiguration);
        return string.substring(matcher.group(1).length());
    }

    @Override
    public int matchingSize(String string) {
        Matcher matcher = this.p.matcher(string);
        if (!matcher.find()) {
            return 0;
        }
        return matcher.group(1).length();
    }
}

