/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.SvgAttributes;

public class CommandCreoleSvgAttributeChange
implements Command {
    private final Pattern pattern;
    public static final String fontPattern = "\\<text[\\s:]+([^>]+)/?\\>";

    public static Command create() {
        return new CommandCreoleSvgAttributeChange("^(?i)(\\<text[\\s:]+([^>]+)/?\\>(.*?)\\</text\\>)");
    }

    public static Command createEol() {
        return new CommandCreoleSvgAttributeChange("^(?i)(\\<text[\\s:]+([^>]+)/?\\>(.*))$");
    }

    private CommandCreoleSvgAttributeChange(String string) {
        this.pattern = MyPattern.cmpile(string);
    }

    @Override
    public int matchingSize(String string) {
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.find()) {
            return 0;
        }
        return matcher.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        FontConfiguration fontConfiguration;
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fontConfiguration2 = fontConfiguration = stripeSimple.getActualFontConfiguration();
        if (matcher.group(2) != null) {
            fontConfiguration2 = fontConfiguration2.changeAttributes(new SvgAttributes(matcher.group(2)));
        }
        stripeSimple.setActualFontConfiguration(fontConfiguration2);
        stripeSimple.analyzeAndAdd(matcher.group(3));
        stripeSimple.setActualFontConfiguration(fontConfiguration);
        return string.substring(matcher.group(1).length());
    }
}

