/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;

public class CommandCreoleUrl
implements Command {
    private final Pattern pattern;
    private final ISkinSimple skinParam;

    public static Command create(ISkinSimple iSkinSimple) {
        return new CommandCreoleUrl(iSkinSimple, "^(" + UrlBuilder.getRegexp() + ")");
    }

    private CommandCreoleUrl(ISkinSimple iSkinSimple, String string) {
        this.pattern = MyPattern.cmpile(string);
        this.skinParam = iSkinSimple;
    }

    @Override
    public int matchingSize(String string) {
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.find()) {
            return 0;
        }
        return matcher.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.find()) {
            throw new IllegalStateException();
        }
        UrlBuilder urlBuilder = new UrlBuilder(this.skinParam.getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
        Url url = urlBuilder.getUrl(matcher.group(1));
        stripeSimple.addUrl(url);
        return string.substring(matcher.group(1).length());
    }
}

