/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.creole.CreoleContext;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.creole.StripeStyle;
import net.sourceforge.plantuml.creole.StripeStyleType;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.utils.CharHidder;

public class CreoleStripeSimpleParser {
    private final String line;
    private final StripeStyle style;
    private final boolean modeSimpleLine;
    private final FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;

    public CreoleStripeSimpleParser(String string, CreoleContext creoleContext, FontConfiguration fontConfiguration, ISkinSimple iSkinSimple, boolean bl) {
        Pattern pattern;
        Matcher matcher;
        Pattern pattern2;
        Matcher matcher2;
        this.fontConfiguration = fontConfiguration;
        this.modeSimpleLine = bl;
        this.skinParam = iSkinSimple;
        Pattern pattern3 = MyPattern.cmpile("^--([^-]*)--$");
        Matcher matcher3 = pattern3.matcher(string);
        if (matcher3.find()) {
            this.line = matcher3.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '-');
            return;
        }
        Pattern pattern4 = MyPattern.cmpile("^==([^=]*)==$");
        Matcher matcher4 = pattern4.matcher(string);
        if (matcher4.find()) {
            this.line = matcher4.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '=');
            return;
        }
        Pattern pattern5 = MyPattern.cmpile("^===*==$");
        Matcher matcher5 = pattern5.matcher(string);
        if (matcher5.find()) {
            this.line = "";
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '=');
            return;
        }
        if (!bl && (matcher2 = (pattern2 = MyPattern.cmpile("^__([^_]*)__$")).matcher(string)).find()) {
            this.line = matcher2.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '_');
            return;
        }
        pattern2 = MyPattern.cmpile("^\\.\\.([^\\.]*)\\.\\.$");
        matcher2 = pattern2.matcher(string);
        if (matcher2.find()) {
            this.line = matcher2.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '.');
            return;
        }
        if (!bl && (matcher = (pattern = MyPattern.cmpile("^(\\*+)([^*]+(?:[^*]|\\*\\*[^*]+\\*\\*)*)$")).matcher(string)).find()) {
            this.line = matcher.group(2).trim();
            int n = matcher.group(1).length() - 1;
            this.style = new StripeStyle(StripeStyleType.LIST_WITHOUT_NUMBER, n, '\u0000');
            return;
        }
        if (!bl && (matcher = (pattern = MyPattern.cmpile("^(#+)(.+)$")).matcher(CharHidder.hide(string))).find()) {
            this.line = CharHidder.unhide(matcher.group(2)).trim();
            int n = CharHidder.unhide(matcher.group(1)).length() - 1;
            this.style = new StripeStyle(StripeStyleType.LIST_WITH_NUMBER, n, '\u0000');
            return;
        }
        pattern = MyPattern.cmpile("^(=+)(.+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.line = matcher.group(2).trim();
            int n = matcher.group(1).length() - 1;
            this.style = new StripeStyle(StripeStyleType.HEADING, n, '\u0000');
            return;
        }
        this.line = string;
        this.style = new StripeStyle(StripeStyleType.NORMAL, 0, '\u0000');
    }

    public Stripe createStripe(CreoleContext creoleContext) {
        StripeSimple stripeSimple = new StripeSimple(this.fontConfiguration, this.style, creoleContext, this.skinParam, this.modeSimpleLine);
        stripeSimple.analyzeAndAdd(this.line);
        return stripeSimple;
    }
}

