/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.Position;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.MinMax;

public class Sea {
    private double currentX;
    private final Map<Atom, Position> positions = new HashMap<Atom, Position>();
    private final StringBounder stringBounder;

    public Sea(StringBounder stringBounder) {
        this.stringBounder = stringBounder;
    }

    public void add(Atom atom) {
        Dimension2D dimension2D = atom.calculateDimension(this.stringBounder);
        Position position = new Position(this.currentX, 0.0, dimension2D);
        this.positions.put(atom, position);
        this.currentX += dimension2D.getWidth();
    }

    public Position getPosition(Atom atom) {
        return this.positions.get(atom);
    }

    public void doAlign() {
        for (Map.Entry<Atom, Position> entry : new HashMap<Atom, Position>(this.positions).entrySet()) {
            Position position = entry.getValue();
            Atom atom = entry.getKey();
            double d = atom.calculateDimension(this.stringBounder).getHeight();
            Position position2 = position.translateY(-d + atom.getStartingAltitude(this.stringBounder));
            this.positions.put(atom, position2);
        }
    }

    public void translateMinYto(double d) {
        double d2 = d - this.getMinY();
        for (Map.Entry<Atom, Position> entry : new HashMap<Atom, Position>(this.positions).entrySet()) {
            Position position = entry.getValue();
            Atom atom = entry.getKey();
            this.positions.put(atom, position.translateY(d2));
        }
    }

    public void exportAllPositions(Map<Atom, Position> map) {
        map.putAll(this.positions);
    }

    public double getMinY() {
        if (this.positions.size() == 0) {
            throw new IllegalStateException();
        }
        double d = Double.MAX_VALUE;
        for (Position position : this.positions.values()) {
            if (!(d > position.getMinY())) continue;
            d = position.getMinY();
        }
        return d;
    }

    public double getMaxY() {
        if (this.positions.size() == 0) {
            throw new IllegalStateException();
        }
        double d = -1.7976931348623157E308;
        for (Position position : this.positions.values()) {
            if (!(d < position.getMaxY())) continue;
            d = position.getMaxY();
        }
        return d;
    }

    public double getHeight() {
        return this.getMaxY() - this.getMinY();
    }

    public MinMax update(MinMax minMax) {
        for (Position position : this.positions.values()) {
            minMax = position.update(minMax);
        }
        return minMax;
    }

    public final double getWidth() {
        return this.currentX;
    }
}

