/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.BlockMember;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public class Bodier {
    private final List<String> rawBody = new ArrayList<String>();
    private final Set<VisibilityModifier> hides;
    private final LeafType type;
    private List<Member> methodsToDisplay;
    private List<Member> fieldsToDisplay;
    private final boolean manageModifier;

    public Bodier(LeafType leafType, Set<VisibilityModifier> set) {
        this.hides = set;
        this.type = leafType;
        this.manageModifier = leafType == null ? false : leafType.manageModifier();
    }

    public void addFieldOrMethod(String string) {
        this.methodsToDisplay = null;
        this.fieldsToDisplay = null;
        this.rawBody.add(string);
    }

    public boolean isBodyEnhanced() {
        for (String string : this.rawBody) {
            if (!BodyEnhanced.isBlockSeparator(string)) continue;
            return true;
        }
        return false;
    }

    public BlockMember getBodyEnhanced() {
        return new BlockMember(){

            @Override
            public TextBlock asTextBlock(FontParam fontParam, ISkinParam iSkinParam) {
                BodyEnhanced bodyEnhanced = new BodyEnhanced(Bodier.this.rawBody, fontParam, iSkinParam, Bodier.this.manageModifier);
                return bodyEnhanced;
            }
        };
    }

    private LeafType getEntityType() {
        return this.type;
    }

    private boolean isMethod(String string) {
        if (this.getEntityType() == LeafType.ANNOTATION || this.getEntityType() == LeafType.ABSTRACT_CLASS || this.getEntityType() == LeafType.CLASS || this.getEntityType() == LeafType.INTERFACE || this.getEntityType() == LeafType.ENUM) {
            return StringUtils.isMethod(string);
        }
        return false;
    }

    public List<Member> getMethodsToDisplay() {
        if (this.methodsToDisplay == null) {
            this.methodsToDisplay = new ArrayList<Member>();
            for (int i = 0; i < this.rawBody.size(); ++i) {
                String string = this.rawBody.get(i);
                if (!this.isMethod(i, this.rawBody) || string.length() == 0 && this.methodsToDisplay.size() == 0) continue;
                Member member = new Member(string, true, this.manageModifier);
                if (this.hides != null && this.hides.contains((Object)member.getVisibilityModifier())) continue;
                this.methodsToDisplay.add(member);
            }
            this.removeFinalEmptyMembers(this.methodsToDisplay);
        }
        return Collections.unmodifiableList(this.methodsToDisplay);
    }

    private boolean isMethod(int n, List<String> list) {
        if (n > 0 && n < list.size() - 1 && list.get(n).length() == 0 && this.isMethod(list.get(n - 1)) && this.isMethod(list.get(n + 1))) {
            return true;
        }
        return this.isMethod(list.get(n));
    }

    public List<Member> getFieldsToDisplay() {
        if (this.fieldsToDisplay == null) {
            this.fieldsToDisplay = new ArrayList<Member>();
            for (String string : this.rawBody) {
                if (this.isMethod(string) || string.length() == 0 && this.fieldsToDisplay.size() == 0) continue;
                Member member = new Member(string, false, this.manageModifier);
                if (this.hides != null && this.hides.contains((Object)member.getVisibilityModifier())) continue;
                this.fieldsToDisplay.add(member);
            }
            this.removeFinalEmptyMembers(this.fieldsToDisplay);
        }
        return Collections.unmodifiableList(this.fieldsToDisplay);
    }

    private void removeFinalEmptyMembers(List<Member> list) {
        while (list.size() > 0 && list.get(list.size() - 1).getDisplay(false).trim().length() == 0) {
            list.remove(list.size() - 1);
        }
    }

    public boolean hasUrl() {
        for (Member member : this.getFieldsToDisplay()) {
            if (!member.hasUrl()) continue;
            return true;
        }
        for (Member member : this.getMethodsToDisplay()) {
            if (!member.hasUrl()) continue;
            return true;
        }
        return true;
    }
}

