/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityGender;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Magma;
import net.sourceforge.plantuml.cucadiagram.MagmaList;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramTxtMaker;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;

public abstract class CucaDiagram
extends UmlDiagram
implements GroupHierarchy,
PortionShower {
    private int horizontalPages = 1;
    private int verticalPages = 1;
    private final Set<LeafType> hiddenType = new HashSet<LeafType>();
    protected final EntityFactory entityFactory = new EntityFactory(this.hiddenType);
    protected IGroup currentGroup = this.entityFactory.getRootGroup();
    private boolean visibilityModifierPresent;
    private String warningOrError;
    private final List<HideOrShow> hideOrShows = new ArrayList<HideOrShow>();
    private final Set<VisibilityModifier> hides = new HashSet<VisibilityModifier>();
    private ILeaf lastEntity = null;

    public abstract IEntity getOrCreateLeaf(Code var1, LeafType var2, USymbol var3);

    public String getNamespaceSeparator() {
        return null;
    }

    @Override
    public boolean hasUrl() {
        for (IEntity removeable : this.getGroups(true)) {
            if (!removeable.hasUrl()) continue;
            return true;
        }
        for (IEntity iEntity : this.getLeafs().values()) {
            if (!iEntity.hasUrl()) continue;
            return true;
        }
        for (Link link : this.getLinks()) {
            if (!link.hasUrl()) continue;
            return true;
        }
        return false;
    }

    protected final ILeaf getOrCreateLeafDefault(Code code, LeafType leafType, USymbol uSymbol) {
        if (leafType == null) {
            throw new IllegalArgumentException();
        }
        ILeaf iLeaf = this.getLeafs().get(code);
        if (iLeaf == null) {
            iLeaf = this.createLeafInternal(code, Display.getWithNewlines(code), leafType, this.getCurrentGroup(), uSymbol);
            iLeaf.setUSymbol(uSymbol);
        }
        this.lastEntity = iLeaf;
        return iLeaf;
    }

    public ILeaf createLeaf(Code code, Display display, LeafType leafType, USymbol uSymbol) {
        if (this.getLeafs().containsKey(code)) {
            throw new IllegalArgumentException("Already known: " + code);
        }
        return this.createLeafInternal(code, display, leafType, this.getCurrentGroup(), uSymbol);
    }

    protected final ILeaf createLeafInternal(Code code, Display display, LeafType leafType, IGroup iGroup, USymbol uSymbol) {
        if (display == null) {
            display = Display.getWithNewlines(code);
        }
        ILeaf iLeaf = this.entityFactory.createLeaf(code, display, leafType, iGroup, this.getHides(), this.getNamespaceSeparator());
        this.entityFactory.addLeaf(iLeaf);
        this.lastEntity = iLeaf;
        iLeaf.setUSymbol(uSymbol);
        return iLeaf;
    }

    public boolean leafExist(Code code) {
        return this.getLeafs().containsKey(code);
    }

    @Override
    public final Collection<IGroup> getChildrenGroups(IGroup iGroup) {
        ArrayList<IGroup> arrayList = new ArrayList<IGroup>();
        for (IGroup iGroup2 : this.getGroups(false)) {
            if (iGroup2.getParentContainer() != iGroup) continue;
            arrayList.add(iGroup2);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public final IGroup getOrCreateGroup(Code code, Display display, GroupType groupType, IGroup iGroup) {
        IGroup iGroup2;
        this.currentGroup = iGroup2 = this.getOrCreateGroupInternal(code, display, null, groupType, iGroup);
        return iGroup2;
    }

    private IGroup getOrCreateGroupInternal(Code code, Display display, Code code2, GroupType groupType, IGroup iGroup) {
        IGroup iGroup2 = this.entityFactory.getGroups().get(code);
        if (iGroup2 != null) {
            return iGroup2;
        }
        if (this.entityFactory.getLeafs().containsKey(code)) {
            iGroup2 = this.entityFactory.muteToGroup(code, code2, groupType, iGroup);
            iGroup2.setDisplay(display);
        } else {
            iGroup2 = this.entityFactory.createGroup(code, display, code2, groupType, iGroup, this.getHides(), this.getNamespaceSeparator());
        }
        this.entityFactory.addGroup(iGroup2);
        return iGroup2;
    }

    public final IGroup getCurrentGroup() {
        return this.currentGroup;
    }

    public final IGroup getGroup(Code code) {
        IGroup iGroup = this.entityFactory.getGroups().get(code);
        if (iGroup == null) {
            throw new IllegalArgumentException();
        }
        return iGroup;
    }

    public void endGroup() {
        if (EntityUtils.groupRoot(this.currentGroup)) {
            Log.error("No parent group");
            return;
        }
        this.currentGroup = this.currentGroup.getParentContainer();
    }

    public final boolean isGroup(Code code) {
        return this.entityFactory.getGroups().containsKey(code);
    }

    public final Collection<IGroup> getGroups(boolean bl) {
        if (!bl) {
            return this.entityFactory.getGroups().values();
        }
        ArrayList<IGroup> arrayList = new ArrayList<IGroup>();
        arrayList.add(this.getRootGroup());
        arrayList.addAll(this.entityFactory.getGroups().values());
        return Collections.unmodifiableCollection(arrayList);
    }

    public IGroup getRootGroup() {
        return this.entityFactory.getRootGroup();
    }

    protected final Map<Code, ILeaf> getLeafs() {
        return this.entityFactory.getLeafs();
    }

    public Collection<ILeaf> getLeafsvalues() {
        return this.getLeafs().values();
    }

    public final int getLeafssize() {
        return this.getLeafs().size();
    }

    public final ILeaf getLeafsget(Code code) {
        return this.getLeafs().get(code);
    }

    public final void addLink(Link link) {
        this.entityFactory.addLink(link);
    }

    protected final void removeLink(Link link) {
        this.entityFactory.removeLink(link);
    }

    public final List<Link> getLinks() {
        return this.entityFactory.getLinks();
    }

    public final int getHorizontalPages() {
        return this.horizontalPages;
    }

    public final void setHorizontalPages(int n) {
        this.horizontalPages = n;
    }

    public final int getVerticalPages() {
        return this.verticalPages;
    }

    public final void setVerticalPages(int n) {
        this.verticalPages = n;
    }

    protected abstract List<String> getDotStrings();

    public final String[] getDotStringSkek() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.getDotStrings()) {
            if (!string.startsWith("nodesep") && !string.startsWith("ranksep")) continue;
            arrayList.add(string);
        }
        String string = this.getPragma().getValue("aspect");
        if (string != null) {
            arrayList.add("aspect=" + (String)string + ";");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void createFilesXmi(OutputStream outputStream, FileFormat fileFormat) throws IOException {
        CucaDiagramXmiMaker cucaDiagramXmiMaker = new CucaDiagramXmiMaker(this, fileFormat);
        cucaDiagramXmiMaker.createFiles(outputStream);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            try {
                this.createFilesTxt(outputStream, n, fileFormat);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(new PrintStream(outputStream));
            }
            return new ImageDataSimple();
        }
        if (fileFormat.name().startsWith("XMI")) {
            this.createFilesXmi(outputStream, fileFormat);
            return new ImageDataSimple();
        }
        if (this.getUmlDiagramType() == UmlDiagramType.COMPOSITE) {
            throw new UnsupportedOperationException();
        }
        CucaDiagramFileMakerSvek cucaDiagramFileMakerSvek = new CucaDiagramFileMakerSvek(this);
        ImageData imageData = cucaDiagramFileMakerSvek.createFile(outputStream, this.getDotStrings(), fileFormatOption);
        if (imageData == null) {
            return new ImageDataSimple();
        }
        this.warningOrError = imageData.getWarningOrError();
        return imageData;
    }

    @Override
    public String getWarningOrError() {
        String string = super.getWarningOrError();
        if (this.warningOrError == null) {
            return string;
        }
        if (string == null) {
            return this.warningOrError;
        }
        return string + "\n" + this.warningOrError;
    }

    private void createFilesTxt(OutputStream outputStream, int n, FileFormat fileFormat) throws IOException {
        CucaDiagramTxtMaker cucaDiagramTxtMaker = new CucaDiagramTxtMaker(this, fileFormat);
        cucaDiagramTxtMaker.createFiles(outputStream, n);
    }

    public boolean isAutarkic(IGroup iGroup) {
        if (iGroup.getGroupType() == GroupType.PACKAGE) {
            return false;
        }
        if (iGroup.getGroupType() == GroupType.INNER_ACTIVITY) {
            return true;
        }
        if (iGroup.getGroupType() == GroupType.CONCURRENT_ACTIVITY) {
            return true;
        }
        if (iGroup.getGroupType() == GroupType.CONCURRENT_STATE) {
            return true;
        }
        if (this.getChildrenGroups(iGroup).size() > 0) {
            return false;
        }
        for (Link removeable : this.getLinks()) {
            if (EntityUtils.isPureInnerLink3(iGroup, removeable)) continue;
            return false;
        }
        for (ILeaf iLeaf : iGroup.getLeafsDirect()) {
            if (iLeaf.getEntityPosition() == EntityPosition.NORMAL) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumber(String string) {
        return string.matches("[+-]?(\\.?\\d+|\\d+\\.\\d*)");
    }

    public void resetPragmaLabel() {
        this.getPragma().undefine("labeldistance");
        this.getPragma().undefine("labelangle");
    }

    public String getLabeldistance() {
        String string;
        if (this.getPragma().isDefine("labeldistance") && CucaDiagram.isNumber(string = this.getPragma().getValue("labeldistance"))) {
            return string;
        }
        if (this.getPragma().isDefine("defaultlabeldistance") && CucaDiagram.isNumber(string = this.getPragma().getValue("defaultlabeldistance"))) {
            return string;
        }
        return "1.7";
    }

    public String getLabelangle() {
        String string;
        if (this.getPragma().isDefine("labelangle") && CucaDiagram.isNumber(string = this.getPragma().getValue("labelangle"))) {
            return string;
        }
        if (this.getPragma().isDefine("defaultlabelangle") && CucaDiagram.isNumber(string = this.getPragma().getValue("defaultlabelangle"))) {
            return string;
        }
        return "25";
    }

    @Override
    public final boolean isEmpty(IGroup iGroup) {
        for (IEntity iEntity : this.getGroups(false)) {
            if (iEntity == iGroup || iEntity.getParentContainer() != iGroup) continue;
            return false;
        }
        return iGroup.size() == 0;
    }

    public final boolean isVisibilityModifierPresent() {
        return this.visibilityModifierPresent;
    }

    public final void setVisibilityModifierPresent(boolean bl) {
        this.visibilityModifierPresent = bl;
    }

    @Override
    public final boolean showPortion(EntityPortion entityPortion, IEntity iEntity) {
        if (this.getSkinParam().strictUmlStyle() && entityPortion == EntityPortion.CIRCLED_CHARACTER) {
            return false;
        }
        boolean bl = true;
        for (HideOrShow hideOrShow : this.hideOrShows) {
            if (hideOrShow.portion != entityPortion || !hideOrShow.gender.contains(iEntity)) continue;
            bl = hideOrShow.show;
        }
        return bl;
    }

    public final void hideOrShow(EntityGender entityGender, Set<EntityPortion> set, boolean bl) {
        for (EntityPortion entityPortion : set) {
            this.hideOrShows.add(new HideOrShow(entityGender, entityPortion, bl));
        }
    }

    public void hideOrShow(Set<VisibilityModifier> set, boolean bl) {
        if (bl) {
            this.hides.removeAll(set);
        } else {
            this.hides.addAll(set);
        }
    }

    public void hideOrShow(ILeaf iLeaf, boolean bl) {
        iLeaf.setRemoved(!bl);
    }

    public void hideOrShow(LeafType leafType, boolean bl) {
        if (bl) {
            this.hiddenType.remove((Object)leafType);
        } else {
            this.hiddenType.add(leafType);
        }
    }

    @Override
    public int getNbImages() {
        return this.horizontalPages * this.verticalPages;
    }

    public final Set<VisibilityModifier> getHides() {
        return Collections.unmodifiableSet(this.hides);
    }

    public ColorMapper getColorMapper() {
        return this.getSkinParam().getColorMapper();
    }

    public final boolean isStandalone(IEntity iEntity) {
        for (Link link : this.getLinks()) {
            if (link.getEntity1() != iEntity && link.getEntity2() != iEntity) continue;
            return false;
        }
        return true;
    }

    public final Link getLastLink() {
        List<Link> list = this.getLinks();
        for (int i = list.size() - 1; i >= 0; --i) {
            Link link = list.get(i);
            if (link.getEntity1().getEntityType() == LeafType.NOTE || link.getEntity2().getEntityType() == LeafType.NOTE) continue;
            return link;
        }
        return null;
    }

    public final ILeaf getLastEntity() {
        return this.lastEntity;
    }

    public final EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public void applySingleStrategy() {
        Object object;
        MagmaList magmaList = new MagmaList();
        for (IGroup iGroup : this.getGroups(true)) {
            object = new ArrayList();
            for (ILeaf iLeaf : iGroup.getLeafsDirect()) {
                if (!this.isStandalone(iLeaf)) continue;
                object.add(iLeaf);
            }
            if (object.size() < 3) continue;
            Magma magma = new Magma(this, (List<ILeaf>)object);
            magma.putInSquare();
            magmaList.add(magma);
        }
        for (IGroup iGroup : this.getGroups(true)) {
            object = magmaList.getMagmas(iGroup);
            if (((MagmaList)object).size() < 3) continue;
            ((MagmaList)object).putInSquare();
        }
    }

    public boolean isHideEmptyDescriptionForState() {
        return false;
    }

    protected void incRawLayout() {
        this.entityFactory.incRawLayout();
    }

    static class HideOrShow {
        private final EntityGender gender;
        private final EntityPortion portion;
        private final boolean show;

        public HideOrShow(EntityGender entityGender, EntityPortion entityPortion, boolean bl) {
            this.gender = entityGender;
            this.portion = entityPortion;
            this.show = bl;
        }
    }
}

