/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.EmbededDiagram;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class Display
implements Iterable<CharSequence> {
    private final List<CharSequence> display = new ArrayList<CharSequence>();
    private final HorizontalAlignment naturalHorizontalAlignment;

    public boolean isWhite() {
        return this.display.size() == 0 || this.display.size() == 1 && this.display.get(0).toString().matches("\\s*");
    }

    public static Display empty() {
        return new Display((HorizontalAlignment)null);
    }

    public static Display create(CharSequence ... charSequenceArray) {
        return Display.create(Arrays.asList(charSequenceArray));
    }

    public static Display create(List<? extends CharSequence> list) {
        return new Display(list, null);
    }

    public static Display getWithNewlines(Code code) {
        return Display.getWithNewlines(code.getFullName());
    }

    public static Display getWithNewlines(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        HorizontalAlignment horizontalAlignment = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i < string.length() - 1) {
                char c2 = string.charAt(i + 1);
                ++i;
                if (c2 == 'n' || c2 == 'r' || c2 == 'l') {
                    if (c2 == 'r') {
                        horizontalAlignment = HorizontalAlignment.RIGHT;
                    } else if (c2 == 'l') {
                        horizontalAlignment = HorizontalAlignment.LEFT;
                    }
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                if (c2 == 't') {
                    stringBuilder.append('\t');
                    continue;
                }
                if (c2 == '\\') {
                    stringBuilder.append(c2);
                    continue;
                }
                stringBuilder.append(c);
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c);
        }
        arrayList.add(stringBuilder.toString());
        return new Display(arrayList, horizontalAlignment);
    }

    private Display(Display display) {
        this(display.naturalHorizontalAlignment);
        this.display.addAll(display.display);
    }

    private Display(HorizontalAlignment horizontalAlignment) {
        this.naturalHorizontalAlignment = horizontalAlignment;
    }

    private Display(List<? extends CharSequence> list, HorizontalAlignment horizontalAlignment) {
        this(horizontalAlignment);
        this.display.addAll(Display.manageEmbededDiagrams2(list));
    }

    private static List<CharSequence> manageEmbededDiagrams2(List<? extends CharSequence> list) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        Iterator<? extends CharSequence> iterator = list.iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence = iterator.next();
            if (charSequence != null && charSequence.toString().trim().equals("{{")) {
                CharSequence charSequence2;
                ArrayList<CharSequence> arrayList2 = new ArrayList<CharSequence>();
                arrayList2.add("@startuml");
                while (iterator.hasNext() && ((charSequence2 = iterator.next()) == null || !charSequence2.toString().trim().equals("}}"))) {
                    arrayList2.add(charSequence2);
                }
                arrayList2.add("@enduml");
                charSequence = new EmbededDiagram(Display.create(arrayList2));
            }
            arrayList.add(charSequence);
        }
        return arrayList;
    }

    public Display underlined() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CharSequence charSequence : this.display) {
            arrayList.add("<u>" + charSequence);
        }
        return new Display(arrayList, this.naturalHorizontalAlignment);
    }

    public String toString() {
        return this.display.toString();
    }

    public int hashCode() {
        return this.display.hashCode();
    }

    public boolean equals(Object object) {
        return this.display.equals(((Display)object).display);
    }

    public Display addAll(Display display) {
        Display display2 = new Display(this);
        display2.display.addAll(display.display);
        return display2;
    }

    public Display addFirst(CharSequence charSequence) {
        Display display = new Display(this);
        display.display.add(0, charSequence);
        return display;
    }

    public Display add(CharSequence charSequence) {
        Display display = new Display(this);
        display.display.add(charSequence);
        return display;
    }

    private boolean firstColumnRemovable() {
        boolean bl = true;
        for (CharSequence charSequence : this) {
            if (charSequence.length() == 0) continue;
            bl = false;
            char c = charSequence.charAt(0);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return !bl;
    }

    public Display removeEmptyColumns() {
        if (!this.firstColumnRemovable()) {
            return this;
        }
        Display display = new Display(this);
        do {
            for (int i = 0; i < display.size(); ++i) {
                CharSequence charSequence = display.get(i);
                if (charSequence.length() <= 0) continue;
                display.display.set(i, charSequence.toString().substring(1));
            }
        } while (display.firstColumnRemovable());
        return display;
    }

    public int size() {
        return this.display.size();
    }

    public CharSequence get(int n) {
        return this.display.get(n);
    }

    @Override
    public Iterator<CharSequence> iterator() {
        return Collections.unmodifiableList(this.display).iterator();
    }

    public Display subList(int n, int n2) {
        return new Display(this.display.subList(n, n2), this.naturalHorizontalAlignment);
    }

    public List<? extends CharSequence> as() {
        return Collections.unmodifiableList(this.display);
    }

    public Url initUrl() {
        if (this.size() == 0) {
            return null;
        }
        UrlBuilder urlBuilder = new UrlBuilder(null, UrlBuilder.ModeUrl.AT_START);
        return urlBuilder.getUrl(this.get(0).toString().trim());
    }

    public Display removeUrl(Url url) {
        if (url == null) {
            return this;
        }
        Display display = new Display(this.naturalHorizontalAlignment);
        display.display.add(UrlBuilder.purgeUrl(this.get(0).toString()));
        display.display.addAll(this.subList((int)1, (int)this.size()).display);
        return display;
    }

    public boolean hasUrl() {
        UrlBuilder urlBuilder = new UrlBuilder(null, UrlBuilder.ModeUrl.ANYWHERE);
        for (CharSequence charSequence : this) {
            if (urlBuilder.getUrl(charSequence.toString()) == null) continue;
            return true;
        }
        return false;
    }

    public HorizontalAlignment getNaturalHorizontalAlignment() {
        return this.naturalHorizontalAlignment;
    }
}

