/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.cucadiagram.Code;

public class Display2
implements Iterable<CharSequence> {
    private final List<CharSequence> display = new ArrayList<CharSequence>();

    public static Display2 empty() {
        return new Display2();
    }

    public static Display2 create(CharSequence ... charSequenceArray) {
        if (charSequenceArray.length == 1 && charSequenceArray[0] == null) {
            return Display2.empty();
        }
        return new Display2(Arrays.asList(charSequenceArray));
    }

    public static Display2 create(List<? extends CharSequence> list) {
        return new Display2(list);
    }

    public static Display2 getWithNewlines(Code code) {
        return Display2.getWithNewlines(code.getFullName());
    }

    public static Display2 getWithNewlines(String string) {
        if (string == null) {
            return null;
        }
        Display2 display2 = new Display2();
        display2.display.addAll(Display2.getWithNewlinesInternal(string));
        return display2;
    }

    private Display2(List<? extends CharSequence> list) {
        for (CharSequence charSequence : list) {
            this.display.addAll(Display2.getWithNewlinesInternal(charSequence));
        }
    }

    private Display2(Display2 display2) {
        this.display.addAll(display2.display);
    }

    private Display2() {
    }

    public Display2 underlined() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CharSequence charSequence : this.display) {
            arrayList.add("<u>" + charSequence);
        }
        return new Display2(arrayList);
    }

    public String toString() {
        return this.display.toString();
    }

    public int hashCode() {
        return this.display.hashCode();
    }

    public boolean equals(Object object) {
        return this.display.equals(((Display2)object).display);
    }

    public Display2 addAll(Display2 display2) {
        Display2 display22 = new Display2(this);
        display22.display.addAll(display2.display);
        return display22;
    }

    public Display2 addFirst(CharSequence charSequence) {
        Display2 display2 = new Display2(this);
        display2.display.addAll(0, Display2.getWithNewlinesInternal(charSequence));
        return display2;
    }

    public Display2 add(CharSequence charSequence) {
        Display2 display2 = new Display2(this);
        display2.display.addAll(Display2.getWithNewlinesInternal(charSequence));
        return display2;
    }

    private boolean firstColumnRemovable() {
        boolean bl = true;
        for (CharSequence charSequence : this) {
            if (charSequence.length() == 0) continue;
            bl = false;
            char c = charSequence.charAt(0);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return !bl;
    }

    public Display2 removeEmptyColumns() {
        if (!this.firstColumnRemovable()) {
            return this;
        }
        Display2 display2 = new Display2(this);
        do {
            for (int i = 0; i < display2.size(); ++i) {
                CharSequence charSequence = display2.get(i);
                if (charSequence.length() <= 0) continue;
                display2.display.set(i, charSequence.toString().substring(1));
            }
        } while (display2.firstColumnRemovable());
        return display2;
    }

    public int size() {
        return this.display.size();
    }

    public CharSequence get(int n) {
        return this.display.get(n);
    }

    @Override
    public Iterator<CharSequence> iterator() {
        return Collections.unmodifiableList(this.display).iterator();
    }

    public Display2 subList(int n, int n2) {
        Display2 display2 = new Display2();
        display2.display.addAll(this.display.subList(n, n2));
        return display2;
    }

    public List<? extends CharSequence> as() {
        return Collections.unmodifiableList(this.display);
    }

    private static List<String> getWithNewlinesInternal(CharSequence charSequence) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\\' && i < charSequence.length() - 1) {
                char c2 = charSequence.charAt(i + 1);
                ++i;
                if (c2 == 'n') {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                if (c2 == 't') {
                    stringBuilder.append('\t');
                    continue;
                }
                if (c2 == '\\') {
                    stringBuilder.append(c2);
                    continue;
                }
                stringBuilder.append(c);
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    public Url initUrl() {
        if (this.size() == 0) {
            return null;
        }
        UrlBuilder urlBuilder = new UrlBuilder(null, UrlBuilder.ModeUrl.AT_START);
        return urlBuilder.getUrl(this.get(0).toString().trim());
    }

    public Display2 removeUrl(Url url) {
        if (url == null) {
            return this;
        }
        Display2 display2 = new Display2();
        display2.display.add(UrlBuilder.purgeUrl(this.get(0).toString()));
        display2.display.addAll(this.subList((int)1, (int)this.size()).display);
        return display2;
    }

    public boolean hasUrl() {
        UrlBuilder urlBuilder = new UrlBuilder(null, UrlBuilder.ModeUrl.ANYWHERE);
        for (CharSequence charSequence : this) {
            if (urlBuilder.getUrl(charSequence.toString()) == null) continue;
            return true;
        }
        return false;
    }
}

