/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public class Member {
    private final String display;
    private final boolean staticModifier;
    private final boolean abstractModifier;
    private final Url url;
    private final boolean hasUrl;
    private final VisibilityModifier visibilityModifier;

    public Member(String string, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        this.hasUrl = new UrlBuilder(null, UrlBuilder.ModeUrl.ANYWHERE).getUrl(string) != null;
        Pattern pattern = MyPattern.cmpile("^(" + UrlBuilder.getRegexp() + ")([^\\[\\]]+)$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            if (matcher.groupCount() != 5) {
                throw new IllegalStateException();
            }
            object2 = new UrlBuilder(null, UrlBuilder.ModeUrl.AT_START);
            this.url = ((UrlBuilder)object2).getUrl(matcher.group(1));
            this.url.setMember(true);
            string = matcher.group(matcher.groupCount()).trim();
        } else {
            object2 = MyPattern.cmpile("^((?:[^\\[\\]]|\\[[^\\[\\]]*\\])+)(" + UrlBuilder.getRegexp() + ")$");
            object = ((Pattern)object2).matcher(string);
            if (((Matcher)object).matches()) {
                if (((Matcher)object).groupCount() != 5) {
                    throw new IllegalStateException();
                }
                UrlBuilder urlBuilder = new UrlBuilder(null, UrlBuilder.ModeUrl.AT_END);
                this.url = urlBuilder.getUrl(((Matcher)object).group(2));
                this.url.setMember(true);
                string = ((Matcher)object).group(1).trim();
            } else {
                this.url = null;
            }
        }
        object2 = StringUtils.goLowerCase(string);
        if (bl2) {
            this.staticModifier = ((String)object2).contains("{static}") || ((String)object2).contains("{classifier}");
            this.abstractModifier = ((String)object2).contains("{abstract}");
            object = string.replaceAll("(?i)\\{(static|classifier|abstract)\\}", "").trim();
            if (((String)object).length() == 0) {
                object = " ";
            }
            if (VisibilityModifier.isVisibilityCharacter(((String)object).charAt(0))) {
                this.visibilityModifier = VisibilityModifier.getVisibilityModifier(string.charAt(0), !bl);
                this.display = ((String)object).substring(1).trim();
            } else {
                this.display = object;
                this.visibilityModifier = null;
            }
        } else {
            this.staticModifier = false;
            this.visibilityModifier = null;
            this.abstractModifier = false;
            this.display = (string = string.trim()).length() == 0 ? " " : string.trim();
        }
    }

    public String getDisplay(boolean bl) {
        if (bl) {
            return this.getDisplayWithVisibilityChar();
        }
        return this.getDisplayWithoutVisibilityChar();
    }

    public String getDisplayWithoutVisibilityChar() {
        return this.display;
    }

    public String getDisplayWithVisibilityChar() {
        if (this.isPrivate()) {
            return "-" + this.display;
        }
        if (this.isPublic()) {
            return "+" + this.display;
        }
        if (this.isPackagePrivate()) {
            return "~" + this.display;
        }
        if (this.isProtected()) {
            return "#" + this.display;
        }
        return this.display;
    }

    public boolean equals(Object object) {
        Member member = (Member)object;
        return this.display.equals(member.display);
    }

    public int hashCode() {
        return this.display.hashCode();
    }

    public final boolean isStatic() {
        return this.staticModifier;
    }

    public final boolean isAbstract() {
        return this.abstractModifier;
    }

    private boolean isPrivate() {
        return this.visibilityModifier == VisibilityModifier.PRIVATE_FIELD || this.visibilityModifier == VisibilityModifier.PRIVATE_METHOD;
    }

    private boolean isProtected() {
        return this.visibilityModifier == VisibilityModifier.PROTECTED_FIELD || this.visibilityModifier == VisibilityModifier.PROTECTED_METHOD;
    }

    private boolean isPublic() {
        return this.visibilityModifier == VisibilityModifier.PUBLIC_FIELD || this.visibilityModifier == VisibilityModifier.PUBLIC_METHOD;
    }

    private boolean isPackagePrivate() {
        return this.visibilityModifier == VisibilityModifier.PACKAGE_PRIVATE_FIELD || this.visibilityModifier == VisibilityModifier.PACKAGE_PRIVATE_METHOD;
    }

    public final VisibilityModifier getVisibilityModifier() {
        return this.visibilityModifier;
    }

    public final Url getUrl() {
        return this.url;
    }

    public boolean hasUrl() {
        return this.hasUrl;
    }
}

