/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Hideable;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.UFont;

public class Stereotype
implements CharSequence,
Hideable {
    private static final Pattern circleChar = MyPattern.cmpile("\\<\\<[%s]*\\(?(\\S)[%s]*,[%s]*(#[0-9a-fA-F]{6}|\\w+)[%s]*(?:[),](.*?))?\\>\\>");
    private static final Pattern circleSprite = MyPattern.cmpile("\\<\\<[%s]*\\(?\\$([\\p{L}0-9_]+)[%s]*(?:,[%s]*(#[0-9a-fA-F]{6}|\\w+))?[%s]*(?:[),](.*?))?\\>\\>");
    private final String label;
    private final HtmlColor htmlColor;
    private final char character;
    private final String sprite;
    private final double radius;
    private final UFont circledFont;
    private final boolean automaticPackageStyle;

    public Stereotype(String string, double d, UFont uFont, IHtmlColorSet iHtmlColorSet) {
        this(string, d, uFont, true, iHtmlColorSet);
    }

    public Stereotype(String string, double d, UFont uFont, boolean bl, IHtmlColorSet iHtmlColorSet) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (!string.startsWith("<<") || !string.endsWith(">>")) {
            throw new IllegalArgumentException(string);
        }
        this.automaticPackageStyle = bl;
        this.radius = d;
        this.circledFont = uFont;
        Matcher matcher = circleChar.matcher(string);
        Matcher matcher2 = circleSprite.matcher(string);
        if (matcher2.find()) {
            this.label = StringUtils.isNotEmpty(matcher2.group(3)) ? "<<" + matcher2.group(3) + ">>" : null;
            String string2 = matcher2.group(2);
            HtmlColor htmlColor = iHtmlColorSet.getColorIfValid(string2);
            this.htmlColor = htmlColor == null ? HtmlColorUtils.BLACK : htmlColor;
            this.sprite = matcher2.group(1);
            this.character = '\u0000';
        } else if (matcher.find()) {
            this.label = StringUtils.isNotEmpty(matcher.group(3)) ? "<<" + matcher.group(3) + ">>" : null;
            String string3 = matcher.group(2);
            this.htmlColor = iHtmlColorSet.getColorIfValid(string3);
            this.character = matcher.group(1).charAt(0);
            this.sprite = null;
        } else {
            this.label = string;
            this.character = '\u0000';
            this.htmlColor = null;
            this.sprite = null;
        }
    }

    public Stereotype(String string) {
        this(string, true);
    }

    public Stereotype(String string, boolean bl) {
        this.automaticPackageStyle = bl;
        this.label = string;
        this.htmlColor = null;
        this.character = '\u0000';
        this.radius = 0.0;
        this.circledFont = null;
        this.sprite = null;
    }

    public HtmlColor getHtmlColor() {
        return this.htmlColor;
    }

    public char getCharacter() {
        return this.character;
    }

    public final String getSprite() {
        return this.sprite;
    }

    public boolean isWithOOSymbol() {
        return "<<O-O>>".equalsIgnoreCase(this.label);
    }

    public String getLabel(boolean bl) {
        assert (this.label == null || this.label.length() > 0);
        if (this.isWithOOSymbol()) {
            return null;
        }
        if (bl) {
            return Stereotype.manageGuillemet(this.label);
        }
        return this.label;
    }

    public boolean isSpotted() {
        return this.character != '\u0000';
    }

    @Override
    public String toString() {
        if (this.label == null) {
            return "" + this.character;
        }
        if (this.character == '\u0000') {
            return this.label;
        }
        return this.character + " " + this.label;
    }

    @Override
    public char charAt(int n) {
        return this.toString().charAt(n);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.toString().subSequence(n, n2);
    }

    public double getRadius() {
        return this.radius;
    }

    public final UFont getCircledFont() {
        return this.circledFont;
    }

    public List<String> getLabels(boolean bl) {
        if (this.getLabel(false) == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = MyPattern.cmpile("\\<\\<.*?\\>\\>");
        Matcher matcher = pattern.matcher(this.getLabel(false));
        while (matcher.find()) {
            if (bl) {
                arrayList.add(Stereotype.manageGuillemet(matcher.group()));
                continue;
            }
            arrayList.add(matcher.group());
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static String manageGuillemet(String string) {
        if (string.startsWith("<< ")) {
            string = "\u00ab" + string.substring(3);
        } else if (string.startsWith("<<")) {
            string = "\u00ab" + string.substring(2);
        }
        if (string.endsWith(" >>")) {
            string = string.substring(0, string.length() - 3) + "\u00bb";
        } else if (string.endsWith(">>")) {
            string = string.substring(0, string.length() - 2) + "\u00bb";
        }
        return string;
    }

    public PackageStyle getPackageStyle() {
        if (!this.automaticPackageStyle) {
            return null;
        }
        for (PackageStyle packageStyle : EnumSet.allOf(PackageStyle.class)) {
            if (!("<<" + (Object)((Object)packageStyle) + ">>").equalsIgnoreCase(this.label)) continue;
            return packageStyle;
        }
        return null;
    }

    @Override
    public boolean isHidden() {
        return "<<hidden>>".equalsIgnoreCase(this.label);
    }
}

