/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Cluster;
import net.sourceforge.plantuml.posimo.GraphvizSolverB;
import net.sourceforge.plantuml.posimo.Path;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public final class CucaDiagramTxtMaker {
    private final FileFormat fileFormat;
    private final UGraphicTxt globalUg = new UGraphicTxt();

    private static double getXPixelPerChar() {
        return 5.0;
    }

    private static double getYPixelPerChar() {
        return 10.0;
    }

    public CucaDiagramTxtMaker(CucaDiagram cucaDiagram, FileFormat fileFormat) throws IOException {
        Object object;
        this.fileFormat = fileFormat;
        Cluster cluster = new Cluster(null, 0.0, 0.0);
        int n = 0;
        HashMap<IEntity, Block> hashMap = new HashMap<IEntity, Block>();
        for (IEntity object22 : cucaDiagram.getLeafsvalues()) {
            double iterator = (double)this.getWidth(object22) * CucaDiagramTxtMaker.getXPixelPerChar();
            double block = (double)this.getHeight(object22) * CucaDiagramTxtMaker.getYPixelPerChar();
            Block block2 = new Block(n++, iterator, block, null);
            cluster.addBloc(block2);
            hashMap.put(object22, block2);
        }
        GraphvizSolverB graphvizSolverB = new GraphvizSolverB();
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (Link link : cucaDiagram.getLinks()) {
            Block block = (Block)hashMap.get(link.getEntity1());
            object = (Block)hashMap.get(link.getEntity2());
            arrayList.add(new Path(block, (Block)object, null, link.getLength()));
        }
        graphvizSolverB.solve(cluster, arrayList);
        for (Path path : arrayList) {
            path.getDotPath().draw(this.globalUg.getCharArea(), CucaDiagramTxtMaker.getXPixelPerChar(), CucaDiagramTxtMaker.getYPixelPerChar());
        }
        for (IEntity iEntity : cucaDiagram.getLeafsvalues()) {
            Block block = (Block)hashMap.get(iEntity);
            object = block.getPosition();
            this.printClass(iEntity, (UGraphicTxt)this.globalUg.apply(new UTranslate(((Point2D)object).getX() / CucaDiagramTxtMaker.getXPixelPerChar(), ((Point2D)object).getY() / CucaDiagramTxtMaker.getYPixelPerChar())));
        }
    }

    private void printClass(IEntity iEntity, UGraphicTxt uGraphicTxt) {
        List<String> list;
        int n = this.getWidth(iEntity);
        int n2 = this.getHeight(iEntity);
        uGraphicTxt.getCharArea().drawBoxSimple(0, 0, n, n2);
        uGraphicTxt.getCharArea().drawStringsLR(iEntity.getDisplay().as(), 1, 1);
        int n3 = 2;
        uGraphicTxt.getCharArea().drawHLine('-', n3, 1, n - 1);
        ++n3;
        for (Member member : iEntity.getFieldsToDisplay()) {
            list = StringUtils.getWithNewlines2(member.getDisplay(true));
            uGraphicTxt.getCharArea().drawStringsLR(list, 1, n3);
            n3 += StringUtils.getHeight(list);
        }
        uGraphicTxt.getCharArea().drawHLine('-', n3, 1, n - 1);
        ++n3;
        for (Member member : iEntity.getMethodsToDisplay()) {
            list = StringUtils.getWithNewlines2(member.getDisplay(true));
            uGraphicTxt.getCharArea().drawStringsLR(list, 1, n3);
            n3 += StringUtils.getHeight(list);
        }
    }

    public List<File> createFiles(File file) throws IOException {
        if (this.fileFormat == FileFormat.UTXT) {
            this.globalUg.getCharArea().print(new PrintStream(file, "UTF-8"));
        } else {
            this.globalUg.getCharArea().print(new PrintStream(file));
        }
        return Collections.singletonList(file);
    }

    private int getHeight(IEntity iEntity) {
        int n = StringUtils.getHeight(iEntity.getDisplay());
        for (Member member : iEntity.getMethodsToDisplay()) {
            n += StringUtils.getHeight(Display.getWithNewlines(member.getDisplay(true)));
        }
        for (Member member : iEntity.getFieldsToDisplay()) {
            n += StringUtils.getHeight(Display.getWithNewlines(member.getDisplay(true)));
        }
        return n + 4;
    }

    private int getWidth(IEntity iEntity) {
        int n;
        int n2 = StringUtils.getWidth(iEntity.getDisplay());
        for (Member member : iEntity.getMethodsToDisplay()) {
            n = StringUtils.getWidth(Display.getWithNewlines(member.getDisplay(true)));
            if (n <= n2) continue;
            n2 = n;
        }
        for (Member member : iEntity.getFieldsToDisplay()) {
            n = StringUtils.getWidth(Display.getWithNewlines(member.getDisplay(true)));
            if (n <= n2) continue;
            n2 = n;
        }
        return n2 + 2;
    }

    public void createFiles(OutputStream outputStream, int n) {
        this.globalUg.getCharArea().print(new PrintStream(outputStream));
    }
}

