/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizLayoutStrategy;
import net.sourceforge.plantuml.cucadiagram.dot.OS;

class OSWindows
extends OS {
    OSWindows() {
    }

    @Override
    File getExecutable(GraphvizLayoutStrategy graphvizLayoutStrategy) {
        File file = graphvizLayoutStrategy.getSystemForcedExecutable();
        if (file != null) {
            return file;
        }
        file = this.searchInDir(new File("c:/Program Files"), graphvizLayoutStrategy);
        if (file != null) {
            return file;
        }
        file = this.searchInDir(new File("c:/Program Files (x86)"), graphvizLayoutStrategy);
        return file;
    }

    private File searchInDir(File file, GraphvizLayoutStrategy graphvizLayoutStrategy) {
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith("Graphviz");
            }
        })) {
            File file3 = new File(new File(file2, "bin"), this.getFileName(graphvizLayoutStrategy));
            if (!file3.exists() || !file3.canRead()) continue;
            arrayList.add(file3.getAbsoluteFile());
        }
        return OSWindows.higherVersion(arrayList);
    }

    static File higherVersion(List<File> list) {
        if (list.size() == 0) {
            return null;
        }
        Collections.sort(list, Collections.reverseOrder());
        return list.get(0);
    }

    @Override
    String getFileName(GraphvizLayoutStrategy graphvizLayoutStrategy) {
        return StringUtils.goLowerCase(graphvizLayoutStrategy.name()) + ".exe";
    }

    @Override
    public String getCommand(GraphvizLayoutStrategy graphvizLayoutStrategy) {
        return "\"" + this.getExecutable(graphvizLayoutStrategy).getAbsolutePath() + "\"";
    }
}

