/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.plantuml.api.MyRunnable;
import net.sourceforge.plantuml.api.TimeoutExecutor;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;

public class ProcessRunner {
    public static long TIMEOUT = 900000L;
    private final String[] cmd;
    private String error;
    private String out;
    private volatile ProcessState state = ProcessState.INIT();
    private final Lock changeState = new ReentrantLock();

    public ProcessRunner(String[] stringArray) {
        this.cmd = stringArray;
    }

    public ProcessState run(byte[] byArray, OutputStream outputStream) {
        return this.run(byArray, outputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessState run(byte[] byArray, OutputStream outputStream, File file) {
        if (this.state.differs(ProcessState.INIT())) {
            throw new IllegalStateException();
        }
        this.state = ProcessState.RUNNING();
        MainThread mainThread = new MainThread(this.cmd, file, outputStream, byArray);
        try {
            boolean bl = new TimeoutExecutor(TIMEOUT).executeNow(mainThread);
        }
        finally {
            this.changeState.lock();
            try {
                if (this.state.equals(ProcessState.RUNNING())) {
                    this.state = ProcessState.TIMEOUT();
                }
            }
            finally {
                this.changeState.unlock();
            }
        }
        if (this.state.equals(ProcessState.TERMINATED_OK())) {
            assert (mainThread != null);
            this.error = mainThread.getError();
            this.out = mainThread.getOut();
        }
        return this.state;
    }

    public final String getError() {
        return this.error;
    }

    public final String getOut() {
        return this.out;
    }

    private void close(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void close(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    class ThreadStream
    extends Thread {
        private volatile InputStream streamToRead;
        private volatile OutputStream redirection;
        private volatile StringBuffer sb = new StringBuffer();

        ThreadStream(InputStream inputStream, OutputStream outputStream) {
            this.streamToRead = inputStream;
            this.redirection = outputStream;
        }

        public String getString() {
            if (this.sb == null) {
                return "";
            }
            return this.sb.toString();
        }

        public void cancel() {
            assert (ProcessRunner.this.state.equals(ProcessState.TIMEOUT()) || ProcessRunner.this.state.equals(ProcessState.RUNNING())) : ProcessRunner.access$000(ProcessRunner.this);
            this.interrupt();
            this.sb = null;
            this.streamToRead = null;
            this.redirection = null;
        }

        @Override
        public void run() {
            int n = 0;
            try {
                while ((n = this.streamToRead.read()) != -1) {
                    if (ProcessRunner.this.state.equals(ProcessState.TIMEOUT())) {
                        return;
                    }
                    if (this.redirection == null) {
                        this.sb.append((char)n);
                        continue;
                    }
                    this.redirection.write(n);
                }
            }
            catch (Throwable throwable) {
                System.err.println("ProcessRunnerA " + throwable);
                throwable.printStackTrace();
                this.sb.append('\n');
                this.sb.append(throwable.toString());
            }
        }
    }

    class MainThread
    implements MyRunnable {
        private final String[] cmd;
        private final File dir;
        private final OutputStream redirection;
        private final byte[] in;
        private volatile Process process;
        private volatile ThreadStream errorStream;
        private volatile ThreadStream outStream;

        public MainThread(String[] stringArray, File file, OutputStream outputStream, byte[] byArray) {
            this.cmd = stringArray;
            this.dir = file;
            this.redirection = outputStream;
            this.in = byArray;
        }

        public String getOut() {
            return this.outStream.getString();
        }

        public String getError() {
            return this.errorStream.getString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() throws InterruptedException {
            try {
                this.startThreads();
                if (ProcessRunner.this.state.equals(ProcessState.RUNNING())) {
                    int n = this.joinInternal();
                }
            }
            finally {
                ProcessRunner.this.changeState.lock();
                try {
                    if (ProcessRunner.this.state.equals(ProcessState.RUNNING())) {
                        ProcessRunner.this.state = ProcessState.TERMINATED_OK();
                    }
                }
                finally {
                    ProcessRunner.this.changeState.unlock();
                }
                if (this.process != null) {
                    this.process.destroy();
                    ProcessRunner.this.close(this.process.getErrorStream());
                    ProcessRunner.this.close(this.process.getOutputStream());
                    ProcessRunner.this.close(this.process.getInputStream());
                }
            }
        }

        @Override
        public void cancelJob() {
            if (this.process != null) {
                this.errorStream.cancel();
                this.outStream.cancel();
                this.process.destroy();
                ProcessRunner.this.close(this.process.getErrorStream());
                ProcessRunner.this.close(this.process.getOutputStream());
                ProcessRunner.this.close(this.process.getInputStream());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startThreads() {
            try {
                this.process = Runtime.getRuntime().exec(this.cmd, null, this.dir);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                ProcessRunner.this.changeState.lock();
                try {
                    ProcessRunner.this.state = ProcessState.IO_EXCEPTION1(iOException);
                }
                finally {
                    ProcessRunner.this.changeState.unlock();
                }
                iOException.printStackTrace();
                return;
            }
            this.errorStream = new ThreadStream(this.process.getErrorStream(), null);
            this.outStream = new ThreadStream(this.process.getInputStream(), this.redirection);
            this.errorStream.start();
            this.outStream.start();
            if (this.in != null) {
                OutputStream outputStream = this.process.getOutputStream();
                try {
                    try {
                        outputStream.write(this.in);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    ProcessRunner.this.changeState.lock();
                    try {
                        ProcessRunner.this.state = ProcessState.IO_EXCEPTION2(iOException);
                    }
                    finally {
                        ProcessRunner.this.changeState.unlock();
                    }
                    iOException.printStackTrace();
                }
            }
        }

        public int joinInternal() throws InterruptedException {
            this.errorStream.join();
            this.outStream.join();
            int n = this.process.waitFor();
            return n;
        }
    }
}

