/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cute.RotationZoom;
import net.sourceforge.plantuml.cute.Segment;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Balloon
implements UDrawable {
    private final Point2D center;
    private final double radius;

    public Balloon(Point2D point2D, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        this.center = point2D;
        this.radius = d;
    }

    public static Balloon fromRadiusSegment(Segment segment) {
        throw new UnsupportedOperationException();
    }

    public Point2D getPointOnCircle(double d) {
        return new Point2D.Double(this.center.getX() + this.radius * Math.cos(d), this.center.getY() + this.radius * Math.sin(d));
    }

    public Segment getSegmentCenterToPointOnCircle(double d) {
        return new Segment(this.center, this.getPointOnCircle(d));
    }

    public Balloon translate(UTranslate uTranslate) {
        return new Balloon(uTranslate.getTranslated(this.center), this.radius);
    }

    public Balloon rotate(RotationZoom rotationZoom) {
        return new Balloon(rotationZoom.getPoint(this.center), rotationZoom.applyZoom(this.radius));
    }

    public String toString() {
        return "Balloon(" + this.center + "," + this.radius + ")";
    }

    public Point2D getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        UEllipse uEllipse = new UEllipse(2.0 * this.radius, 2.0 * this.radius);
        uGraphic.apply(new UTranslate(this.center.getX() - uEllipse.getWidth() / 2.0, this.center.getY() - uEllipse.getHeight() / 2.0)).draw(uEllipse);
    }

    public Balloon getInsideTangentBalloon1(double d, double d2) {
        double d3 = this.radius - d2;
        double d4 = (this.radius * this.radius - d3 * d3) / 2.0 / this.radius;
        RotationZoom rotationZoom = RotationZoom.rotationInRadians(d);
        Point2D.Double double_ = rotationZoom.getPoint(d3, d4);
        Point2D.Double double_2 = new Point2D.Double(this.center.getX() + ((Point2D)double_).getX(), this.center.getY() + ((Point2D)double_).getY());
        return new Balloon(double_2, d4);
    }

    public Balloon getInsideTangentBalloon2(double d, double d2) {
        double d3 = this.radius - d2;
        double d4 = (this.radius * this.radius - d3 * d3) / 2.0 / this.radius;
        RotationZoom rotationZoom = RotationZoom.rotationInRadians(d);
        Point2D.Double double_ = rotationZoom.getPoint(d3, -d4);
        Point2D.Double double_2 = new Point2D.Double(this.center.getX() + ((Point2D)double_).getX(), this.center.getY() + ((Point2D)double_).getY());
        return new Balloon(double_2, d4);
    }

    public Point2D getPointOnCirclePassingByThisPoint(Point2D point2D) {
        Segment segment = new Segment(this.center, point2D);
        return segment.getFromAtoB(this.radius);
    }

    public Point2D getPointOnCircleOppositeToThisPoint(Point2D point2D) {
        Segment segment = new Segment(this.center, point2D);
        return segment.getFromAtoB(-this.radius);
    }
}

