/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.util.Map;
import net.sourceforge.plantuml.cute.Cheese;
import net.sourceforge.plantuml.cute.Circle;
import net.sourceforge.plantuml.cute.CuteShape;
import net.sourceforge.plantuml.cute.Group;
import net.sourceforge.plantuml.cute.Positionned;
import net.sourceforge.plantuml.cute.PositionnedImpl;
import net.sourceforge.plantuml.cute.Rectangle;
import net.sourceforge.plantuml.cute.Stick;
import net.sourceforge.plantuml.cute.Triangle;
import net.sourceforge.plantuml.cute.VarArgs;

public class CuteShapeFactory {
    private final Map<String, Group> groups;

    public CuteShapeFactory(Map<String, Group> map) {
        this.groups = map;
    }

    public Positionned createCuteShapePositionned(String string) {
        VarArgs varArgs = new VarArgs(string);
        return new PositionnedImpl(this.createCuteShape(string), varArgs);
    }

    private CuteShape createCuteShape(String string) {
        string = string.toLowerCase().trim();
        VarArgs varArgs = new VarArgs(string);
        if (string.startsWith("circle ")) {
            return new Circle(varArgs);
        }
        if (string.startsWith("cheese ")) {
            return new Cheese(varArgs);
        }
        if (string.startsWith("stick ")) {
            return new Stick(varArgs);
        }
        if (string.startsWith("rectangle ") || string.startsWith("rect ")) {
            return new Rectangle(varArgs);
        }
        if (string.startsWith("triangle ")) {
            return new Triangle(varArgs);
        }
        String string2 = string.split(" ")[0];
        System.err.println("Looking for group " + string2 + " in " + this.groups.keySet());
        Group group = this.groups.get(string2);
        if (group == null) {
            throw new IllegalArgumentException("Cannot find group " + string2 + " in " + this.groups.keySet());
        }
        System.err.println("Found group " + string2 + " in " + this.groups.keySet());
        return group;
    }
}

