/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.cute.Positionned;
import net.sourceforge.plantuml.cute.RotationZoom;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Group
implements Positionned {
    private final String groupName;
    private final List<Positionned> shapes;
    private final Group parent;
    private final Map<String, Group> children;

    public String toString() {
        return "Group " + this.groupName + " (" + this.shapes.size() + ") ";
    }

    public static Group createRoot() {
        return new Group(null, "ROOT");
    }

    private Group(Group group, String string) {
        this.parent = group;
        this.groupName = string;
        this.shapes = new ArrayList<Positionned>();
        this.children = new HashMap<String, Group>();
    }

    private Group(Group group, String string, List<Positionned> list) {
        this.parent = group;
        this.groupName = string;
        this.shapes = list;
        this.children = null;
    }

    public Group createChild(String string) {
        Group group = new Group(this, string);
        this.children.put(string, group);
        return group;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        for (Positionned positionned : this.shapes) {
            positionned.drawU(uGraphic);
        }
    }

    public void add(Positionned positionned) {
        this.shapes.add(positionned);
    }

    public String getName() {
        return this.groupName;
    }

    @Override
    public Positionned rotateZoom(RotationZoom rotationZoom) {
        if (rotationZoom.isNone()) {
            return this;
        }
        ArrayList<Positionned> arrayList = new ArrayList<Positionned>();
        for (Positionned positionned : this.shapes) {
            arrayList.add(positionned.rotateZoom(rotationZoom));
        }
        return new Group(this.parent, this.groupName + "->" + rotationZoom, arrayList);
    }

    @Override
    public Positionned translate(UTranslate uTranslate) {
        throw new UnsupportedOperationException();
    }

    public Group getParent() {
        return this.parent;
    }

    public Map<String, Group> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }
}

