/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cute.Arc;
import net.sourceforge.plantuml.cute.CutePath;
import net.sourceforge.plantuml.cute.CuteShape;
import net.sourceforge.plantuml.cute.MyPoint2D;
import net.sourceforge.plantuml.cute.RotationZoom;
import net.sourceforge.plantuml.cute.VarArgs;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;

public class Rectangle
implements CuteShape {
    private final double width;
    private final double height;
    private final RotationZoom rotationZoom;
    private final double curvation;

    public Rectangle(VarArgs varArgs) {
        Point2D point2D = varArgs.getAsPoint("dimension");
        this.width = point2D.getX();
        this.height = point2D.getY();
        this.rotationZoom = RotationZoom.none();
        this.curvation = varArgs.getAsDouble("curve", 0.0);
    }

    private Rectangle(double d, double d2, RotationZoom rotationZoom, double d3) {
        this.width = d;
        this.height = d2;
        this.rotationZoom = rotationZoom;
        this.curvation = d3;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        CutePath cutePath = new CutePath();
        cutePath.add(new Arc(MyPoint2D.from(0.0, 0.0).withCurvation(this.curvation), MyPoint2D.from(this.width, 0.0).withCurvation(this.curvation)));
        cutePath.add(new Arc(MyPoint2D.from(this.width, 0.0).withCurvation(this.curvation), MyPoint2D.from(this.width, this.height).withCurvation(this.curvation)));
        cutePath.add(new Arc(MyPoint2D.from(this.width, this.height).withCurvation(this.curvation), MyPoint2D.from(0.0, this.height).withCurvation(this.curvation)));
        cutePath.add(new Arc(MyPoint2D.from(0.0, this.height).withCurvation(this.curvation), MyPoint2D.from(0.0, 0.0).withCurvation(this.curvation)));
        cutePath = cutePath.rotateZoom(this.rotationZoom);
        cutePath.drawU(uGraphic);
    }

    public void drawUOld(UGraphic uGraphic) {
        UPath uPath = new UPath();
        if (this.curvation == 0.0) {
            uPath.moveTo(this.rotationZoom.getPoint(0.0, 0.0));
            uPath.lineTo(this.rotationZoom.getPoint(this.width, 0.0));
            uPath.lineTo(this.rotationZoom.getPoint(this.width, this.height));
            uPath.lineTo(this.rotationZoom.getPoint(0.0, this.height));
            uPath.lineTo(this.rotationZoom.getPoint(0.0, 0.0));
        } else {
            uPath.moveTo(this.rotationZoom.getPoint(this.width, this.curvation));
            uPath.lineTo(this.rotationZoom.getPoint(this.width, this.height - this.curvation));
            uPath.arcTo(this.rotationZoom.getPoint(this.width - this.curvation, this.height), this.curvation, 0.0, 1.0);
            uPath.lineTo(this.rotationZoom.getPoint(this.curvation, this.height));
            uPath.arcTo(this.rotationZoom.getPoint(0.0, this.height - this.curvation), this.curvation, 0.0, 1.0);
            uPath.lineTo(this.rotationZoom.getPoint(0.0, this.curvation));
            uPath.arcTo(this.rotationZoom.getPoint(this.curvation, 0.0), this.curvation, 0.0, 1.0);
            uPath.lineTo(this.rotationZoom.getPoint(this.width - this.curvation, 0.0));
            uPath.arcTo(this.rotationZoom.getPoint(this.width, this.curvation), this.curvation, 0.0, 1.0);
        }
        uPath.closePath();
        uGraphic.draw(uPath);
    }

    @Override
    public Rectangle rotateZoom(RotationZoom rotationZoom) {
        return new Rectangle(this.width, this.height, this.rotationZoom.compose(rotationZoom), this.curvation);
    }
}

