/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ditaa;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.core.ProcessingOptions;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.TextGrid;

public class PSystemDitaa
extends AbstractPSystem {
    private final ProcessingOptions processingOptions = new ProcessingOptions();
    private final boolean dropShadows;
    private final String data;

    public PSystemDitaa(String string, boolean bl, boolean bl2) {
        this.data = string;
        this.dropShadows = bl2;
        this.processingOptions.setPerformSeparationOfCommonEdges(bl);
    }

    PSystemDitaa add(String string) {
        return new PSystemDitaa(this.data + string + "\n", this.processingOptions.performSeparationOfCommonEdges(), this.dropShadows);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Ditaa)", this.getClass());
    }

    @Override
    public ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        if (fileFormatOption.getFileFormat() == FileFormat.ATXT) {
            outputStream.write(this.getSource().getPlainString().getBytes());
            return new ImageDataSimple();
        }
        ConversionOptions conversionOptions = new ConversionOptions();
        conversionOptions.setDropShadows(this.dropShadows);
        TextGrid textGrid = new TextGrid();
        textGrid.initialiseWithText(this.data, null);
        Diagram diagram = new Diagram(textGrid, conversionOptions, this.processingOptions);
        BufferedImage bufferedImage = (BufferedImage)new BitmapRenderer().renderToImage(diagram, conversionOptions.renderingOptions);
        ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
        return new ImageDataSimple(bufferedImage.getWidth(), bufferedImage.getHeight());
    }
}

