/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends AbstractPSystem {
    public static final String DONORS = "UDfTaikosZ0CXlTw2gypquT8IOTEu5pcqEcYEv7e41sCH6s7DddwYhR11gsiqUtx9TU--cyKu9KI1LTBKc7iu1jLsVG4MyrkY50lfRY7TSWXcc17Uuo9KTop3WArz1hSMYdDT7s-lrl6aeu2Mom6IOA65uSzrBcrNc0tPeG9rbpTcoYq2-KOOPVeF92ubUhPz3NB78gmEJsKQe2LUXRtfcCaQCU7UFMX9cHnpWnF1JMUIjT6rPv-e_IspjN0rlM0OJAbRpVPSe3daZxDyEBvOWKDTqSZlqLOu4kyjPO2eg8BDFE9KvZS5WVj4ThhqdyCQEsBl8fyFfVPSR8r2IRBCpxZQl_1q_5EbVHtxjzAjaRUobv2uXc-vd2lyCJTGDvzHlPJgS3F9KoCZsWjeNngiVivKdJDk0zef_LP_dVzIDGDRXCmOaOwaFtOue2_hX_DKjn6Bmn_0C5QlDy0";

    @Override
    public ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        GraphicStrings graphicStrings = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, graphicStrings.getBackcolor(), this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.addUDrawable(graphicStrings);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption.getFileFormat(), outputStream);
    }

    private GraphicStrings getGraphicStrings() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<b>Special thanks to our sponsors and donors !");
        arrayList.add(" ");
        int n = 0;
        List<String> list = this.getDonors();
        int n2 = (list.size() + 1) / 2;
        for (String object2 : list) {
            arrayList.add(object2);
            if (++n != n2) continue;
            arrayList.add(" ");
            arrayList.add(" ");
            n = 0;
        }
        arrayList.add(" ");
        UFont uFont = new UFont("SansSerif", 0, 12);
        GraphicStrings graphicStrings = new GraphicStrings(arrayList, uFont, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON, PSystemVersion.getPlantumlImage(), GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT);
        graphicStrings.setMaxLine(n2 + 2);
        return graphicStrings;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        TranscoderImpl transcoderImpl = new TranscoderImpl();
        String string = transcoderImpl.decode(DONORS).replace('*', '.');
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Donors)", this.getClass());
    }

    public static PSystemDonors create() {
        return new PSystemDonors();
    }
}

