/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ftp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.core.DiagramDescription;

public class FtpConnexion {
    private final String user;
    private final Map<String, String> incoming = new HashMap<String, String>();
    private final Map<String, byte[]> outgoing = new HashMap<String, byte[]>();
    private final Set<String> futureOutgoing = new HashSet<String>();
    private FileFormat fileFormat;

    public FtpConnexion(String string, FileFormat fileFormat) {
        this.user = string;
        this.fileFormat = fileFormat;
    }

    public synchronized void addIncoming(String string, String string2) {
        if (string.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        this.incoming.put(string, string2);
    }

    public synchronized void futureOutgoing(String string) {
        this.outgoing.remove(string);
        this.futureOutgoing.add(string);
    }

    public synchronized Collection<String> getFiles() {
        ArrayList<String> arrayList = new ArrayList<String>(this.incoming.keySet());
        arrayList.addAll(this.outgoing.keySet());
        return Collections.unmodifiableCollection(arrayList);
    }

    public synchronized boolean willExist(String string) {
        if (this.incoming.containsKey(string)) {
            return true;
        }
        if (this.outgoing.containsKey(string)) {
            return true;
        }
        return this.futureOutgoing.contains(string);
    }

    public synchronized byte[] getData(String string) throws InterruptedException {
        if (string.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        String string2 = this.incoming.get(string);
        if (string2 != null) {
            return string2.getBytes();
        }
        while (this.willExist(string)) {
            byte[] byArray = this.outgoing.get(string);
            if (byArray != null) {
                return byArray;
            }
            Thread.sleep(200L);
        }
        return null;
    }

    public synchronized int getSize(String string) {
        if (string.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        String string2 = this.incoming.get(string);
        if (string2 != null) {
            return string2.length();
        }
        byte[] byArray = this.outgoing.get(string);
        if (byArray != null) {
            return byArray.length;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processImage(String string) throws IOException {
        if (string.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        String string2 = this.getFutureFileName(string);
        boolean bl = false;
        try {
            SourceStringReader sourceStringReader = new SourceStringReader(this.incoming.get(string));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FileFormat fileFormat = this.getFileFormat();
            DiagramDescription diagramDescription = sourceStringReader.generateDiagramDescription((OutputStream)byteArrayOutputStream, new FileFormatOption(fileFormat));
            String string3 = string2.substring(0, string2.length() - 4) + ".err";
            FtpConnexion ftpConnexion = this;
            synchronized (ftpConnexion) {
                this.outgoing.remove(string2);
                this.futureOutgoing.remove(string2);
                this.outgoing.remove(string3);
                if (diagramDescription != null && diagramDescription.getDescription() != null) {
                    this.outgoing.put(string2, byteArrayOutputStream.toByteArray());
                    bl = true;
                    if (diagramDescription.getDescription().startsWith("(Error)")) {
                        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                        sourceStringReader.generateImage((OutputStream)byteArrayOutputStream2, new FileFormatOption(FileFormat.ATXT));
                        byteArrayOutputStream2.close();
                        this.outgoing.put(string3, byteArrayOutputStream2.toByteArray());
                    }
                }
            }
        }
        finally {
            if (!bl) {
                this.outgoing.put(string2, new byte[0]);
            }
        }
    }

    public String getFutureFileName(String string) {
        return this.getFileFormat().changeName(string, 0);
    }

    private FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public synchronized void delete(String string) {
        this.incoming.remove(string);
        this.outgoing.remove(string);
        this.futureOutgoing.add(string);
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }
}

