/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ftp;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.ftp.FtpConnexion;
import net.sourceforge.plantuml.ftp.FtpServer;

class FtpLoop
implements Runnable {
    private final Socket incoming;
    private final FtpServer ftpServer;
    private final BufferedReader br;
    private final PrintWriter pw;
    private FtpConnexion connexion;
    private String ipClient = null;
    private int port = -1;
    private Mode mode;

    public FtpLoop(Socket socket, FtpServer ftpServer) throws IOException {
        this.incoming = socket;
        this.ftpServer = ftpServer;
        this.br = new BufferedReader(new InputStreamReader(this.incoming.getInputStream(), ftpServer.getCharset()));
        this.pw = new PrintWriter(this.incoming.getOutputStream(), true);
    }

    private void runInternal() throws IOException, InterruptedException {
        String string;
        boolean bl;
        this.localLog("Starting Loop");
        this.myOut("220 PlantUML");
        do {
            string = this.br.readLine();
            this.localLog("s=" + string);
            if (string != null) continue;
            this.pw.close();
            this.br.close();
            return;
        } while (!(bl = this.manage(string)));
    }

    private boolean manage(String string) throws UnknownHostException, IOException, InterruptedException {
        String string2 = StringUtils.goUpperCase(string);
        if (string2.startsWith("USER")) {
            this.myOut("331 Password required");
            String string3 = string.substring("USER ".length());
            this.connexion = this.ftpServer.getFtpConnexion(string3);
        } else if (string2.startsWith("PASS")) {
            this.myOut("230 Logged in.");
        } else if (string2.startsWith("PWD")) {
            this.myOut("257 \"/\" is current directory.");
        } else if (string2.startsWith("CWD")) {
            String string4 = string.substring("CWD ".length());
            this.myOut("250 \"" + string4 + "\" is new working directory..");
        } else if (string2.startsWith("TYPE")) {
            this.myOut("200 Command okay.");
        } else if (string2.startsWith("PORT")) {
            this.mode = Mode.ACTIF;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            stringTokenizer.nextToken();
            this.ipClient = stringTokenizer.nextToken() + "." + stringTokenizer.nextToken() + "." + stringTokenizer.nextToken() + "." + stringTokenizer.nextToken();
            this.port = Integer.parseInt(stringTokenizer.nextToken()) * 256 + Integer.parseInt(stringTokenizer.nextToken());
            this.myOut("200 Command okay.");
        } else if (string2.startsWith("LIST")) {
            if (this.mode == Mode.ACTIF) {
                this.listActif();
            } else {
                this.listPassif();
            }
        } else if (string2.startsWith("STOR")) {
            if (this.mode == Mode.ACTIF) {
                this.storActif(string);
            } else {
                this.storPassif(string);
            }
        } else if (string2.startsWith("PASV")) {
            this.mode = Mode.PASSIF;
            this.port = this.ftpServer.getFreePort();
            int n = this.port / 256;
            int n2 = this.port % 256;
            assert (this.port == n * 256 + n2);
            this.localLog("adr=" + this.incoming.getInetAddress().getHostAddress());
            String string5 = this.ftpServer.getIpServer();
            this.localLog("server=" + string5);
            this.myOut("227 Entering Passive Mode (" + string5.replace('.', ',') + "," + n + "," + n2 + ").");
            this.ipClient = string5;
        } else if (string2.startsWith("RETR")) {
            if (this.mode == Mode.ACTIF) {
                this.retrActif(string);
            } else {
                this.retrPassif(string);
            }
        } else if (string2.startsWith("DELE")) {
            String string6 = string.substring("DELE ".length());
            this.connexion.delete(string6);
            this.myOut("200 Command okay.");
        } else {
            if (string2.startsWith("QUIT")) {
                this.myOut("221 Goodbye.");
                return true;
            }
            if (string2.startsWith("SYST")) {
                this.myOut("215 UNIX Type: L8.");
            } else {
                this.myOut("502 Command not implemented.");
            }
        }
        return false;
    }

    private void localLog(String string) {
    }

    private void retr(String string, Socket socket) throws UnknownHostException, IOException, InterruptedException {
        OutputStream outputStream = socket.getOutputStream();
        byte[] byArray = this.connexion.getData(string);
        if (byArray != null) {
            outputStream.write(byArray);
        }
        outputStream.flush();
        outputStream.close();
        socket.close();
        this.myOut("226 Transfer complete.");
    }

    private void retrPassif(String string) throws UnknownHostException, IOException, InterruptedException {
        String string2 = string.substring("STOR ".length());
        if (!this.connexion.willExist(string2 = this.removeStartingsSlash(string2))) {
            this.myOut("550 No such file.");
            return;
        }
        this.myOut("150 Opening");
        ServerSocket serverSocket = new ServerSocket(this.port);
        Socket socket = serverSocket.accept();
        this.retr(string2, socket);
        serverSocket.close();
    }

    private void retrActif(String string) throws UnknownHostException, IOException, InterruptedException {
        String string2 = string.substring("STOR ".length());
        if (!this.connexion.willExist(string2 = this.removeStartingsSlash(string2))) {
            this.myOut("550 No such file.");
            return;
        }
        this.myOut("150 Opening");
        Socket socket = new Socket(this.ipClient, this.port);
        this.retr(string2, socket);
    }

    private void storActif(String string) throws IOException {
        String string2 = this.removeStartingsSlash(string.substring("STOR ".length()));
        this.myOut("150 FILE: " + string2);
        Socket socket = new Socket(this.ipClient, this.port);
        this.stor(string2, socket);
    }

    private void storPassif(String string) throws IOException {
        String string2 = this.removeStartingsSlash(string.substring("STOR ".length()));
        this.myOut("150 FILE: " + string2);
        ServerSocket serverSocket = new ServerSocket(this.port);
        Socket socket = serverSocket.accept();
        this.stor(string2, socket);
        serverSocket.close();
    }

    private String removeStartingsSlash(String string) {
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    private void stor(String string, Socket socket) throws UnknownHostException, IOException {
        InputStream inputStream = socket.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtils.copyToStream(inputStream, (OutputStream)byteArrayOutputStream);
        this.myOut("226 Transfer complete.");
        if ("png".equalsIgnoreCase(string)) {
            this.connexion.setFileFormat(FileFormat.PNG);
        } else if ("svg".equalsIgnoreCase(string)) {
            this.connexion.setFileFormat(FileFormat.SVG);
        } else if ("eps".equalsIgnoreCase(string)) {
            this.connexion.setFileFormat(FileFormat.EPS);
        }
        if (string.length() > 3) {
            String string2 = new String(byteArrayOutputStream.toByteArray(), this.ftpServer.getCharset());
            String string3 = this.connexion.getFutureFileName(string);
            this.connexion.futureOutgoing(string3);
            this.connexion.addIncoming(string, string2);
            this.ftpServer.processImage(this.connexion, string);
        }
    }

    private void listActif() throws UnknownHostException, IOException {
        this.myOut("150 Opening ASCII mode data");
        Socket socket = new Socket(this.ipClient, this.port);
        this.list(socket);
    }

    private void listPassif() throws UnknownHostException, IOException {
        this.myOut("150 Opening ASCII mode data");
        ServerSocket serverSocket = new ServerSocket(this.port);
        Socket socket = serverSocket.accept();
        this.list(socket);
        serverSocket.close();
    }

    private void list(Socket socket) throws IOException {
        PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
        Collection<String> collection = this.connexion.getFiles();
        if (collection.size() > 0) {
            int n = 0;
            for (String string : collection) {
                n += (this.connexion.getSize(string) + 511) / 512;
            }
            printWriter.println("total " + n);
            for (String string : collection) {
                String string2 = String.format("%10s %4d %-8s %-8s %8d %3s %2s %5s %s", "-rw-rw-r--", 1, "plantuml", "plantuml", this.connexion.getSize(string), "Sep", 28, 2006, string);
                printWriter.println(string2);
            }
        }
        printWriter.flush();
        printWriter.close();
        socket.close();
        this.myOut("226 Listing completed.");
    }

    private void myOut(String string) {
        if (string.indexOf(9) != -1) {
            throw new IllegalArgumentException();
        }
        this.pw.println(string);
        this.pw.flush();
    }

    @Override
    public void run() {
        try {
            this.runInternal();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static enum Mode {
        ACTIF,
        PASSIF;

    }
}

