/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.geom.Dijkstra;
import net.sourceforge.plantuml.geom.LineSegmentInt;
import net.sourceforge.plantuml.geom.Neighborhood;
import net.sourceforge.plantuml.geom.Orientation;
import net.sourceforge.plantuml.geom.Point2DInt;
import net.sourceforge.plantuml.geom.Pointable;
import net.sourceforge.plantuml.geom.Polyline;
import net.sourceforge.plantuml.geom.PolylineImpl;
import net.sourceforge.plantuml.geom.Singularity;

abstract class AbstractFigure {
    private final Set<LineSegmentInt> segments = new HashSet<LineSegmentInt>();

    AbstractFigure() {
    }

    public String toString() {
        return this.segments.toString();
    }

    public final boolean equals(Object object) {
        AbstractFigure abstractFigure = (AbstractFigure)object;
        return this.segments.equals(abstractFigure.segments);
    }

    public final int hashCode() {
        return this.segments.hashCode();
    }

    protected boolean knowThisPoint(Point2DInt point2DInt) {
        for (LineSegmentInt lineSegmentInt : this.segments) {
            if (!lineSegmentInt.getP1().equals(point2DInt) && !lineSegmentInt.getP2().equals(point2DInt)) continue;
            return true;
        }
        return false;
    }

    LineSegmentInt existingSegment(Point2DInt point2DInt, Point2DInt point2DInt2) {
        for (LineSegmentInt lineSegmentInt : this.segments) {
            if (lineSegmentInt.getP1().equals(point2DInt) && lineSegmentInt.getP2().equals(point2DInt2)) {
                return lineSegmentInt;
            }
            if (!lineSegmentInt.getP1().equals(point2DInt2) || !lineSegmentInt.getP2().equals(point2DInt)) continue;
            return lineSegmentInt;
        }
        return null;
    }

    Collection<LineSegmentInt> getSegmentsWithExtremity(Point2DInt point2DInt, Collection<LineSegmentInt> collection) {
        HashSet<LineSegmentInt> hashSet = new HashSet<LineSegmentInt>();
        for (LineSegmentInt lineSegmentInt : this.segments) {
            if (collection.contains(lineSegmentInt) || !lineSegmentInt.getP1().equals(point2DInt) && !lineSegmentInt.getP2().equals(point2DInt)) continue;
            hashSet.add(lineSegmentInt);
        }
        return Collections.unmodifiableCollection(hashSet);
    }

    public void addSegment(LineSegmentInt lineSegmentInt) {
        this.segments.add(lineSegmentInt);
    }

    protected final Set<LineSegmentInt> getSegments() {
        return Collections.unmodifiableSet(this.segments);
    }

    @Deprecated
    public Polyline addPath(Point2DInt point2DInt, Point2DInt point2DInt2) {
        if (this.knowThisPoint(point2DInt) && this.knowThisPoint(point2DInt2)) {
            return this.getPath(point2DInt, point2DInt2);
        }
        LineSegmentInt lineSegmentInt = new LineSegmentInt(point2DInt, point2DInt2);
        this.addSegment(lineSegmentInt);
        return new PolylineImpl(point2DInt, point2DInt2);
    }

    public Polyline addDirectLink(Point2DInt point2DInt, Point2DInt point2DInt2) {
        LineSegmentInt lineSegmentInt = new LineSegmentInt(point2DInt, point2DInt2);
        this.addSegment(lineSegmentInt);
        Log.println("AbstractFigure::addDirectLink " + lineSegmentInt);
        return new PolylineImpl(point2DInt, point2DInt2);
    }

    public boolean isSimpleSegmentPossible(Point2DInt point2DInt, Point2DInt point2DInt2) {
        LineSegmentInt lineSegmentInt = new LineSegmentInt(point2DInt, point2DInt2);
        return !this.hasIntersectionStrict(lineSegmentInt);
    }

    public Polyline getPath(Pointable pointable, Pointable pointable2) {
        if (!this.knowThisPoint(pointable.getPosition())) {
            throw new IllegalArgumentException();
        }
        if (!this.knowThisPoint(pointable2.getPosition())) {
            throw new IllegalArgumentException("" + pointable2.getPosition());
        }
        if (this.isSimpleSegmentPossible(pointable.getPosition(), pointable2.getPosition())) {
            throw new IllegalArgumentException();
        }
        if (!this.arePointsConnectable(pointable.getPosition(), pointable2.getPosition())) {
            return null;
        }
        return this.findBestPath(pointable, pointable2);
    }

    private Polyline findBestPath(Pointable pointable, Pointable pointable2) {
        int n;
        Log.println("start=" + pointable.getPosition());
        Log.println("end=" + pointable2.getPosition());
        Set<Point2DInt> set = this.getAllPoints();
        if (!set.contains(pointable.getPosition()) || !set.contains(pointable2.getPosition())) {
            throw new IllegalArgumentException();
        }
        set.remove(pointable.getPosition());
        set.remove(pointable2.getPosition());
        ArrayList<Neighborhood> arrayList = new ArrayList<Neighborhood>();
        for (Point2DInt point2DInt : set) {
            arrayList.addAll(this.getSingularity(point2DInt).getNeighborhoods());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Log.println("N" + (i + 1) + " " + arrayList.get(i));
        }
        Dijkstra dijkstra = new Dijkstra(arrayList.size() + 2);
        Log.println("size=" + dijkstra.getSize());
        for (n = 0; n < arrayList.size(); ++n) {
            if (!this.isConnectable(pointable.getPosition(), (Neighborhood)arrayList.get(n))) continue;
            dijkstra.addLink(0, n + 1, AbstractFigure.distance(pointable.getPosition(), ((Neighborhood)arrayList.get(n)).getCenter()));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (n == i || !this.isConnectable((Neighborhood)arrayList.get(n), (Neighborhood)arrayList.get(i))) continue;
                dijkstra.addLink(n + 1, i + 1, AbstractFigure.distance(((Neighborhood)arrayList.get(n)).getCenter(), ((Neighborhood)arrayList.get(i)).getCenter()));
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (!this.isConnectable(pointable2.getPosition(), (Neighborhood)arrayList.get(n))) continue;
            dijkstra.addLink(n + 1, arrayList.size() + 1, AbstractFigure.distance(pointable2.getPosition(), ((Neighborhood)arrayList.get(n)).getCenter()));
        }
        List<Integer> list = dijkstra.getBestPath();
        if (list.get(list.size() - 1) != arrayList.size() + 1) {
            throw new IllegalStateException("No Path");
        }
        assert (list.size() > 2);
        Log.println("PATH=" + list);
        ArrayList<Neighborhood> arrayList2 = new ArrayList<Neighborhood>();
        for (int i = 1; i < list.size() - 1; ++i) {
            int n2 = list.get(i) - 1;
            arrayList2.add((Neighborhood)arrayList.get(n2));
        }
        return this.findApproximatePath(pointable, pointable2, arrayList2);
    }

    private Polyline findApproximatePath(Pointable pointable, Pointable pointable2, List<Neighborhood> list) {
        System.err.println("findApproximatePath " + pointable.getPosition() + " " + pointable2.getPosition() + " " + list);
        PolylineImpl polylineImpl = new PolylineImpl(pointable, pointable2);
        for (Neighborhood neighborhood : list) {
            Log.println("Neighborhood =" + neighborhood);
            double d = this.getProximaDistance(neighborhood.getCenter()) / 2.0;
            double d2 = neighborhood.getMiddle();
            Log.println("d=" + d);
            Log.println("a=" + d2 * 180.0 / Math.PI);
            double d3 = d * Math.cos(d2);
            double d4 = d * Math.sin(d2);
            assert (d > 0.0);
            Log.println("Result = " + neighborhood.getCenter().translate((int)d3, (int)d4));
            polylineImpl.addIntermediate(neighborhood.getCenter().translate((int)d3, (int)d4));
        }
        return polylineImpl;
    }

    private double getProximaDistance(Point2DInt point2DInt) {
        double d = Double.MAX_VALUE;
        for (Point2DInt point2DInt2 : this.getAllPoints()) {
            if (point2DInt.equals(point2DInt2)) continue;
            double d2 = new LineSegmentInt(point2DInt2, point2DInt).getLength();
            d = Math.min(d, d2);
        }
        return d;
    }

    private static double distance(Point2DInt point2DInt, Point2DInt point2DInt2) {
        return new LineSegmentInt(point2DInt, point2DInt2).getLength();
    }

    public boolean isConnectable(Point2DInt point2DInt, Neighborhood neighborhood) {
        LineSegmentInt lineSegmentInt = new LineSegmentInt(neighborhood.getCenter(), point2DInt);
        if (this.hasIntersectionStrict(lineSegmentInt)) {
            return false;
        }
        double d = Singularity.convertAngle(lineSegmentInt.getAngle());
        return neighborhood.isInAngleLarge(d);
    }

    public boolean isConnectable(Neighborhood neighborhood, Neighborhood neighborhood2) {
        boolean bl = this.isConnectableInternal(neighborhood, neighborhood2);
        assert (bl == this.isConnectableInternal(neighborhood2, neighborhood));
        return bl;
    }

    private boolean isConnectableInternal(Neighborhood neighborhood, Neighborhood neighborhood2) {
        if (neighborhood.getCenter().equals(neighborhood2.getCenter())) {
            return false;
        }
        LineSegmentInt lineSegmentInt = new LineSegmentInt(neighborhood.getCenter(), neighborhood2.getCenter());
        if (this.hasIntersectionStrict(lineSegmentInt)) {
            return false;
        }
        double d = Singularity.convertAngle(lineSegmentInt.getAngle());
        double d2 = Singularity.convertAngle(lineSegmentInt.getOppositeAngle());
        assert (d2 == Singularity.convertAngle(new LineSegmentInt(neighborhood2.getCenter(), neighborhood.getCenter()).getAngle()));
        if (neighborhood.isInAngleStrict(d) && neighborhood2.isInAngleStrict(d2)) {
            return true;
        }
        if (neighborhood.isAngleLimit(d) && neighborhood2.isAngleLimit(d2)) {
            Orientation orientation;
            if (neighborhood.is360() || neighborhood2.is360()) {
                return true;
            }
            Orientation orientation2 = neighborhood.getOrientationFrom(d);
            return orientation2 != (orientation = neighborhood2.getOrientationFrom(d2));
        }
        return false;
    }

    private boolean hasIntersectionStrict(LineSegmentInt lineSegmentInt) {
        for (LineSegmentInt lineSegmentInt2 : this.getSegments()) {
            if (lineSegmentInt2.atLeastOneCommonExtremities(lineSegmentInt) || !lineSegmentInt2.doesIntersect(lineSegmentInt)) continue;
            Log.println("seg=" + lineSegmentInt2);
            Log.println("direct=" + lineSegmentInt);
            Log.println("AbstractFigure::hasIntersectionStrict true");
            return true;
        }
        Log.println("AbstractFigure::hasIntersectionStrict false");
        return false;
    }

    public Singularity getSingularity(Point2DInt point2DInt) {
        Singularity singularity = new Singularity(point2DInt);
        for (LineSegmentInt lineSegmentInt : this.getSegments()) {
            if (!lineSegmentInt.containsPoint(point2DInt)) continue;
            singularity.addLineSegment(lineSegmentInt);
        }
        return singularity;
    }

    private Set<Point2DInt> getAllPoints() {
        HashSet<Point2DInt> hashSet = new HashSet<Point2DInt>();
        for (LineSegmentInt lineSegmentInt : this.segments) {
            hashSet.add(lineSegmentInt.getP1());
            hashSet.add(lineSegmentInt.getP2());
        }
        return hashSet;
    }

    abstract boolean arePointsConnectable(Point2DInt var1, Point2DInt var2);
}

