/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom.kinetic;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class SegmentCutter {
    private final List<Point2D> intermediates = new ArrayList<Point2D>();

    public SegmentCutter(Point2D point2D, Point2D point2D2, double d) {
        double d2 = point2D2.distance(point2D);
        if (d2 <= d) {
            this.intermediates.add(point2D2);
            return;
        }
        int n = 2;
        while (d2 / (double)n > d) {
            ++n;
        }
        double d3 = point2D2.getX() - point2D.getX();
        double d4 = point2D2.getY() - point2D.getY();
        for (int i = 1; i < n; ++i) {
            this.intermediates.add(new Point2D.Double(point2D.getX() + (double)i * d3 / (double)n, point2D.getY() + (double)i * d4 / (double)n));
        }
        this.intermediates.add(point2D2);
    }

    public List<Point2D> intermediates() {
        return Collections.unmodifiableList(this.intermediates);
    }
}

