/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.LenghtLinkComparator;
import net.sourceforge.plantuml.graph.Move;

public class Board {
    private final List<ALink> links;
    private final Map<ALink, Integer> initialDirection;
    private final Map<ANode, Integer> nodesCols = new LinkedHashMap<ANode, Integer>();
    private int hashcodeValue;
    private boolean hashcodeComputed = false;

    private Board(Board board) {
        this.links = board.links;
        this.initialDirection = board.initialDirection;
        this.nodesCols.putAll(board.nodesCols);
    }

    public Comparator<ALink> getLinkComparator() {
        return new LenghtLinkComparator(this.nodesCols);
    }

    public boolean equals(Object object) {
        Board board = (Board)object;
        if (this.links != board.links) {
            return false;
        }
        Iterator<Integer> iterator = this.nodesCols.values().iterator();
        Iterator<Integer> iterator2 = board.nodesCols.values().iterator();
        assert (this.nodesCols.size() == board.nodesCols.size());
        while (iterator.hasNext()) {
            if (iterator.next().equals(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashcodeComputed) {
            return this.hashcodeValue;
        }
        this.hashcodeValue = 13;
        for (Integer n : this.nodesCols.values()) {
            this.hashcodeValue = this.hashcodeValue * 17 + n;
        }
        this.hashcodeComputed = true;
        return this.hashcodeValue;
    }

    public void normalize() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (Map.Entry<ANode, Integer> entry : this.nodesCols.entrySet()) {
            n = Math.min(n, entry.getKey().getRow());
            n3 = Math.max(n3, entry.getKey().getRow());
            n2 = Math.min(n2, entry.getValue());
            n4 = Math.max(n4, entry.getValue());
        }
        for (Map.Entry<ANode, Integer> entry : this.nodesCols.entrySet()) {
            if (n != 0) {
                entry.getKey().setRow(entry.getKey().getRow() - n);
            }
            if (n2 == 0) continue;
            entry.setValue(entry.getValue() - n2);
        }
    }

    private void normalizeCol() {
        int n = Collections.min(this.nodesCols.values());
        if (n != 0) {
            for (Map.Entry<ANode, Integer> entry : this.nodesCols.entrySet()) {
                entry.setValue(entry.getValue() - n);
            }
        }
    }

    void internalMove(String string, int n) {
        this.hashcodeComputed = false;
        for (ANode aNode : this.nodesCols.keySet()) {
            if (!aNode.getCode().equals(string)) continue;
            this.nodesCols.put(aNode, n);
            return;
        }
    }

    public Board copy() {
        return new Board(this);
    }

    public Board(List<ANode> list, List<ALink> list2) {
        for (ANode object : list) {
            this.addInRow(object);
        }
        this.links = Collections.unmodifiableList(new ArrayList<ALink>(list2));
        this.initialDirection = new HashMap<ALink, Integer>();
        for (ALink aLink : list2) {
            this.initialDirection.put(aLink, this.getDirection(aLink));
        }
    }

    public int getInitialDirection(ALink aLink) {
        return this.initialDirection.get(aLink);
    }

    public int getDirection(ALink aLink) {
        return this.getCol(aLink.getNode2()) - this.getCol(aLink.getNode1());
    }

    private void addInRow(ANode aNode) {
        this.hashcodeComputed = false;
        int n = 0;
        while (true) {
            if (this.getNodeAt(aNode.getRow(), n) == null) {
                this.nodesCols.put(aNode, n);
                assert (this.getNodeAt(aNode.getRow(), n) == aNode);
                return;
            }
            ++n;
        }
    }

    public Collection<ANode> getNodes() {
        return Collections.unmodifiableCollection(this.nodesCols.keySet());
    }

    public Collection<ANode> getNodesInRow(int n) {
        ArrayList<ANode> arrayList = new ArrayList<ANode>();
        for (ANode aNode : this.nodesCols.keySet()) {
            if (aNode.getRow() != n) continue;
            arrayList.add(aNode);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public final List<? extends ALink> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public int getCol(ANode aNode) {
        return this.nodesCols.get(aNode);
    }

    public void applyMove(Move move) {
        ANode aNode = this.getNodeAt(move.getRow(), move.getCol());
        if (aNode == null) {
            throw new IllegalArgumentException();
        }
        ANode aNode2 = this.getNodeAt(move.getRow(), move.getNewCol());
        this.nodesCols.put(aNode, move.getNewCol());
        if (aNode2 != null) {
            this.nodesCols.put(aNode2, move.getCol());
        }
        this.normalizeCol();
        this.hashcodeComputed = false;
    }

    public Collection<Move> getAllPossibleMoves() {
        ArrayList<Move> arrayList = new ArrayList<Move>();
        for (Map.Entry<ANode, Integer> entry : this.nodesCols.entrySet()) {
            int n = entry.getKey().getRow();
            int n2 = entry.getValue();
            arrayList.add(new Move(n, n2, -1));
            arrayList.add(new Move(n, n2, 1));
        }
        return arrayList;
    }

    public ANode getNodeAt(int n, int n2) {
        for (Map.Entry<ANode, Integer> entry : this.nodesCols.entrySet()) {
            if (entry.getKey().getRow() != n || entry.getValue() != n2) continue;
            return entry.getKey();
        }
        return null;
    }

    public Set<ANode> getConnectedNodes(ANode aNode, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return Collections.singleton(aNode);
        }
        HashSet<ANode> hashSet = new HashSet<ANode>();
        if (n == 1) {
            for (ALink aLink : this.links) {
                if (aLink.getNode1() == aNode) {
                    hashSet.add(aLink.getNode2());
                    continue;
                }
                if (aLink.getNode2() != aNode) continue;
                hashSet.add(aLink.getNode1());
            }
        } else {
            for (ANode aNode2 : this.getConnectedNodes(aNode, n - 1)) {
                hashSet.addAll(this.getConnectedNodes(aNode2, 1));
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<ALink> getAllLinks(Set<ANode> set) {
        HashSet<ALink> hashSet = new HashSet<ALink>();
        for (ALink aLink : this.links) {
            if (!set.contains(aLink.getNode1()) && !set.contains(aLink.getNode2())) continue;
            hashSet.add(aLink);
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

