/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.CostComputer;
import net.sourceforge.plantuml.graph.SortedCollection;
import net.sourceforge.plantuml.graph.SortedCollectionArrayList;

public class BoardCollection {
    private final SortedCollection<Entry> all = new SortedCollectionArrayList<Entry>();
    private final CostComputer costComputer;

    public BoardCollection(CostComputer costComputer) {
        this.costComputer = costComputer;
    }

    public int size() {
        return this.all.size();
    }

    public Board getAndSetExploredSmallest() {
        for (Entry entry : this.all) {
            if (entry.explored) continue;
            entry.explored = true;
            assert (this.costComputer.getCost(entry.board) == entry.cost);
            return entry.board;
        }
        return null;
    }

    public double getBestCost() {
        Iterator iterator = this.all.iterator();
        if (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            return entry.cost;
        }
        return 0.0;
    }

    public Board getBestBoard() {
        Iterator iterator = this.all.iterator();
        if (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            return entry.board;
        }
        return null;
    }

    public List<Double> getCosts() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (Entry entry : this.all) {
            arrayList.add(this.costComputer.getCost(entry.board));
        }
        return arrayList;
    }

    public void add(Board board) {
        this.all.add(new Entry(board, this.costComputer));
    }

    public boolean contains(Board board) {
        return this.all.contains(new Entry(board, null));
    }

    static class Entry
    implements Comparable<Entry> {
        private final Board board;
        private final double cost;
        private boolean explored;

        public Entry(Board board, CostComputer costComputer) {
            this.board = board;
            this.cost = costComputer == null ? 0.0 : costComputer.getCost(board);
        }

        @Override
        public int compareTo(Entry entry) {
            return (int)Math.signum(this.cost - entry.cost);
        }

        public boolean equals(Object object) {
            Entry entry = (Entry)object;
            return this.board.equals(entry.board);
        }

        public int hashCode() {
            return this.board.hashCode();
        }
    }
}

