/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.EntityImageFactory;
import net.sourceforge.plantuml.graph2.IInflationTransform;
import net.sourceforge.plantuml.graph2.InflationTransform2;
import net.sourceforge.plantuml.graph2.Plan;
import net.sourceforge.plantuml.graph2.Polyline2;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;

public class Graph5 {
    private static final Graphics2D dummyGraphics2D;
    private final int spaceWidth = 40;
    private final int spaceHeight = 40;
    private final double margin = 20.0;
    private final Board board;
    private int maxRow;
    private int maxCol;
    private final Plan plan = new Plan();
    private final IInflationTransform inflationTransform = new InflationTransform2();

    private AbstractEntityImage getImage(ANode aNode) {
        return new EntityImageFactory().createEntityImage((IEntity)aNode.getUserData());
    }

    public Graph5(Board board) {
        Object object;
        board.normalize();
        this.board = board;
        for (ANode aNode : board.getNodes()) {
            this.maxRow = Math.max(this.maxRow, aNode.getRow());
            this.maxCol = Math.max(this.maxCol, board.getCol(aNode));
            object = this.getPosition(aNode);
            this.plan.addPoint2D((Point2D.Double)object);
        }
        for (ANode aNode : board.getNodes()) {
            object = this.getImage(aNode);
            Point2D.Double double_ = this.getPosition(aNode);
            int n = (int)((AbstractEntityImage)object).getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D)).getWidth() + 20;
            int n2 = (int)((AbstractEntityImage)object).getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D)).getHeight() + 20;
            this.inflationTransform.addInflationX(double_.getX(), n);
            this.inflationTransform.addInflationY(double_.getY(), n2);
        }
    }

    public Point2D.Double getPosition(ANode aNode) {
        return new Point2D.Double(this.board.getCol(aNode) * 40, aNode.getRow() * 40);
    }

    public Dimension2D getDimension() {
        double d = 40 * this.maxCol;
        int n = 40 * this.maxRow;
        return new Dimension2DDouble(d + 40.0 + this.inflationTransform.getTotalInflationX(), (double)n + 40.0 + this.inflationTransform.getTotalInflationY());
    }

    public void draw(Graphics2D graphics2D) {
        Point2D point2D;
        Object object;
        graphics2D.translate(20.0, 20.0);
        graphics2D.setColor(Color.BLUE);
        for (ALink object2 : this.getSortedLinks()) {
            object = this.getPosition(object2.getNode1());
            point2D = this.getPosition(object2.getNode2());
            List<Line2D.Double> list = this.buildPath((Point2D)object, point2D);
            Polyline2 polyline2 = this.buildPolyline((Point2D)object, point2D, list);
            polyline2.draw(graphics2D);
        }
        for (ANode aNode : this.board.getNodes()) {
            object = this.getImage(aNode);
            point2D = this.getPosition(aNode);
            point2D = this.inflationTransform.inflatePoint2D(point2D);
            double d = point2D.getX() - ((AbstractEntityImage)object).getDimension(StringBounderUtils.asStringBounder(graphics2D)).getWidth() / 2.0;
            double d2 = point2D.getY() - ((AbstractEntityImage)object).getDimension(StringBounderUtils.asStringBounder(graphics2D)).getHeight() / 2.0;
            graphics2D.translate(d, d2);
            ((AbstractEntityImage)object).draw(new ColorMapperIdentity(), graphics2D);
            graphics2D.translate(-d, -d2);
        }
    }

    private Polyline2 buildPolyline(Point2D point2D, Point2D point2D2, List<Line2D.Double> list) {
        Polyline2 polyline2 = new Polyline2(this.inflationTransform.inflatePoint2D(point2D), this.inflationTransform.inflatePoint2D(point2D2));
        List<Line2D.Double> list2 = this.inflationTransform.inflate(list);
        for (Line2D.Double double_ : list2) {
            polyline2.addLine(double_);
        }
        return polyline2;
    }

    private List<Line2D.Double> buildPath(Point2D point2D, Point2D point2D2) {
        Point2D point2D3 = point2D;
        List<Point2D.Double> list = this.plan.getIntermediatePoints(point2D, point2D2);
        ArrayList<Line2D.Double> arrayList = new ArrayList<Line2D.Double>();
        for (Point2D.Double double_ : list) {
            this.plan.addPoint2D(double_);
            arrayList.add(new Line2D.Double(point2D3, double_));
            this.plan.createLink(point2D3, double_);
            point2D3 = double_;
        }
        arrayList.add(new Line2D.Double(point2D3, point2D2));
        this.plan.createLink(point2D3, point2D2);
        return arrayList;
    }

    private List<ALink> getSortedLinks() {
        final LinkedHashMap<ALink, Double> linkedHashMap = new LinkedHashMap<ALink, Double>();
        for (ALink aLink : this.board.getLinks()) {
            Point2D.Double double_ = this.getPosition(aLink.getNode1());
            Point2D.Double double_2 = this.getPosition(aLink.getNode2());
            linkedHashMap.put(aLink, double_.distance(double_2));
        }
        ArrayList arrayList = new ArrayList(linkedHashMap.keySet());
        Collections.sort(arrayList, new Comparator<ALink>(){

            @Override
            public int compare(ALink aLink, ALink aLink2) {
                double d = (Double)linkedHashMap.get(aLink) - (Double)linkedHashMap.get(aLink2);
                return (int)Math.signum(d);
            }
        });
        return arrayList;
    }

    static {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, Color.WHITE);
        dummyGraphics2D = emptyImageBuilder.getGraphics2D();
    }
}

