/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.graph.SortedCollection;

public class SortedCollectionArrayList<S extends Comparable<S>>
implements SortedCollection<S> {
    private final List<S> allAsList = new ArrayList<S>();
    private final Set<S> allAsSet = new HashSet<S>();

    @Override
    public Iterator<S> iterator() {
        return this.allAsList.iterator();
    }

    @Override
    public void add(S s) {
        int n = Collections.binarySearch(this.allAsList, s);
        if (n >= 0) {
            this.allAsList.add(n, s);
        } else {
            this.allAsList.add(-1 - n, s);
        }
        this.allAsSet.add(s);
        assert (this.isSorted());
    }

    @Override
    public int size() {
        assert (this.allAsSet.size() == this.allAsList.size());
        return this.allAsList.size();
    }

    List<S> toList() {
        return new ArrayList<S>(this.allAsList);
    }

    boolean isSorted() {
        Comparable comparable = null;
        for (Comparable comparable2 : this.allAsList) {
            if (comparable != null && comparable2.compareTo(comparable) < 0) {
                return false;
            }
            comparable = comparable2;
        }
        return true;
    }

    @Override
    public boolean contains(S s) {
        return this.allAsSet.contains(s);
    }
}

