/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.ANodeImpl;
import net.sourceforge.plantuml.graph.Heap;
import net.sourceforge.plantuml.graph.LinkString;

public class Zoda2 {
    private final Map<ANode, Heap> heaps = new LinkedHashMap<ANode, Heap>();

    public ANode getNode(String string) {
        for (ANode aNode : this.heaps.keySet()) {
            if (!aNode.getCode().equals(string)) continue;
            return aNode;
        }
        return null;
    }

    public ANode createAloneNode(String string) {
        if (this.getNode(string) != null) {
            throw new IllegalArgumentException();
        }
        Heap heap = new Heap();
        ANode aNode = heap.addNode(string);
        this.heaps.put(aNode, heap);
        return aNode;
    }

    public List<? extends ANode> getNodes() {
        return Collections.unmodifiableList(new ArrayList<ANode>(this.heaps.keySet()));
    }

    public Set<Heap> getHeaps() {
        return new HashSet<Heap>(this.heaps.values());
    }

    public void addLink(String string, int n, Object object) {
        Heap heap;
        LinkString linkString;
        try {
            linkString = new LinkString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return;
        }
        ANode aNode = this.getNode(linkString.getNode1());
        ANode aNode2 = this.getNode(linkString.getNode2());
        Heap heap2 = aNode == null ? null : this.heaps.get(aNode);
        Heap heap3 = heap = aNode2 == null ? null : this.heaps.get(aNode2);
        assert (heap2 == null || !heap2.isEmpty());
        assert (heap == null || !heap.isEmpty());
        if (heap2 == null && heap == null) {
            Heap heap4 = new Heap();
            heap4.addLink(string, n, object);
            this.recordHeap(heap4);
        } else if (heap2 == heap) {
            assert (heap2 != null && heap != null);
            heap2.addLink(string, n, object);
        } else if (heap2 == null) {
            heap.addLink(string, n, object);
            this.recordHeap(heap);
        } else if (heap == null) {
            heap2.addLink(string, n, object);
            this.recordHeap(heap2);
        } else {
            assert (heap2 != null && heap != null);
            assert (heap2.getNodes().contains(aNode));
            heap2.importing(aNode, aNode2, heap, n, object);
            this.recordHeap(heap2);
            assert (this.heapMerged(heap2, heap));
        }
    }

    private boolean heapMerged(Heap heap, Heap heap2) {
        for (ANode aNode : heap2.getNodes()) {
            assert (this.heaps.get(aNode) == heap);
        }
        return true;
    }

    private void recordHeap(Heap heap) {
        for (ANode aNode : heap.getNodes()) {
            this.heaps.put((ANodeImpl)aNode, heap);
        }
    }
}

