/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.graph2.Measurer;
import net.sourceforge.plantuml.graph2.SortedListImpl;

public class RectanglesCollection
implements Iterable<Rectangle2D.Double> {
    private final List<Rectangle2D.Double> areas = new ArrayList<Rectangle2D.Double>();
    private final SortedListImpl<Rectangle2D.Double> sortedX1 = new SortedListImpl<Rectangle2D.Double>(new Measurer<Rectangle2D.Double>(){

        @Override
        public int getMeasure(Rectangle2D.Double double_) {
            return (int)double_.x;
        }
    });
    private final SortedListImpl<Rectangle2D.Double> sortedX2 = new SortedListImpl<Rectangle2D.Double>(new Measurer<Rectangle2D.Double>(){

        @Override
        public int getMeasure(Rectangle2D.Double double_) {
            return (int)(double_.x + double_.width);
        }
    });
    private final SortedListImpl<Rectangle2D.Double> sortedY1 = new SortedListImpl<Rectangle2D.Double>(new Measurer<Rectangle2D.Double>(){

        @Override
        public int getMeasure(Rectangle2D.Double double_) {
            return (int)double_.y;
        }
    });
    private final SortedListImpl<Rectangle2D.Double> sortedY2 = new SortedListImpl<Rectangle2D.Double>(new Measurer<Rectangle2D.Double>(){

        @Override
        public int getMeasure(Rectangle2D.Double double_) {
            return (int)(double_.y + double_.height);
        }
    });
    private Rectangle2D.Double max = null;
    private static long TPS1;
    private static long TPS2;

    public RectanglesCollection() {
    }

    public RectanglesCollection(Rectangle2D.Double double_) {
        this();
        this.add(double_);
    }

    public double getSurf() {
        if (this.max == null) {
            return 0.0;
        }
        return this.max.getWidth() * this.max.getHeight();
    }

    public void add(Rectangle2D.Double double_) {
        this.areas.add(double_);
        this.max = this.max == null ? double_ : (Rectangle2D.Double)this.max.createUnion(double_);
    }

    @Override
    public Iterator<Rectangle2D.Double> iterator() {
        return this.areas.iterator();
    }

    public boolean intersect(RectanglesCollection rectanglesCollection) {
        if (this.size() > rectanglesCollection.size()) {
            return RectanglesCollection.intersectSeveral(this, rectanglesCollection);
        }
        return RectanglesCollection.intersectSeveral(rectanglesCollection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean intersectSeveral(RectanglesCollection rectanglesCollection, RectanglesCollection rectanglesCollection2) {
        assert (rectanglesCollection.size() >= rectanglesCollection2.size());
        long l = System.currentTimeMillis();
        try {
            for (Rectangle2D.Double double_ : rectanglesCollection2) {
                if (!rectanglesCollection.intersectSimple(double_)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            TPS2 += System.currentTimeMillis() - l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean intersectSimple(Rectangle2D.Double double_) {
        long l = System.currentTimeMillis();
        try {
            if (this.max == null || !this.max.intersects(double_)) {
                boolean bl = false;
                return bl;
            }
            for (Rectangle2D.Double double_2 : this.areas) {
                if (!double_.intersects(double_2)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            TPS1 += System.currentTimeMillis() - l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean intersectSimpleOld(Rectangle2D.Double double_) {
        long l = System.currentTimeMillis();
        try {
            List<Rectangle2D.Double> list;
            List<Rectangle2D.Double> list2;
            List<Rectangle2D.Double> list3;
            if (this.max == null || !this.max.intersects(double_)) {
                boolean bl = false;
                return bl;
            }
            List<Rectangle2D.Double> list4 = list3 = this.sortedX1.lesserOrEquals((int)(double_.x + double_.width));
            if (list3.size() == 0) {
                boolean bl = false;
                return bl;
            }
            List<Rectangle2D.Double> list5 = this.sortedX2.biggerOrEquals((int)double_.x);
            if (list5.size() == 0) {
                boolean bl = false;
                return bl;
            }
            if (list5.size() < list4.size()) {
                list4 = list5;
            }
            if ((list2 = this.sortedY1.lesserOrEquals((int)(double_.y + double_.height))).size() == 0) {
                boolean bl = false;
                return bl;
            }
            if (list2.size() < list4.size()) {
                list4 = list2;
            }
            if ((list = this.sortedY2.biggerOrEquals((int)double_.y)).size() == 0) {
                boolean bl = false;
                return bl;
            }
            if (list.size() < list4.size()) {
                list4 = list;
            }
            for (Rectangle2D.Double double_2 : list4) {
                if (!double_.intersects(double_2)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            TPS1 += System.currentTimeMillis() - l;
        }
    }

    public int size() {
        return this.areas.size();
    }

    public void addAll(RectanglesCollection rectanglesCollection) {
        for (Rectangle2D.Double double_ : rectanglesCollection.areas) {
            this.add(double_);
        }
    }
}

