/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.graph2.Measurer;
import net.sourceforge.plantuml.graph2.SortedList;

public class SortedListImpl<V>
implements SortedList<V> {
    private final Measurer<V> measurer;
    private final List<V> all = new ArrayList<V>();
    private final Comparator<V> comparator;

    public SortedListImpl(Measurer<V> measurer) {
        this.measurer = measurer;
        this.comparator = new Comparator<V>(){

            @Override
            public int compare(V v, V v2) {
                int n = SortedListImpl.this.measurer.getMeasure(v);
                int n2 = SortedListImpl.this.measurer.getMeasure(v2);
                return n - n2;
            }
        };
    }

    @Override
    public void add(V v) {
        int n = Collections.binarySearch(this.all, v, this.comparator);
        if (n >= 0) {
            this.all.add(n, v);
        } else {
            this.all.add(-n - 1, v);
        }
        assert (this.isSorted());
    }

    private int getPos(int n, boolean bl) {
        final NullableAndEvenMeasurer<V> nullableAndEvenMeasurer = new NullableAndEvenMeasurer<V>(this.measurer, n, bl);
        Comparator comparator = new Comparator<V>(){

            @Override
            public int compare(V v, V v2) {
                int n = nullableAndEvenMeasurer.getMeasure(v);
                int n2 = nullableAndEvenMeasurer.getMeasure(v2);
                return n - n2;
            }
        };
        int n2 = Collections.binarySearch(this.all, null, comparator);
        assert (n2 < 0);
        return -n2 - 1;
    }

    @Override
    public List<V> lesserOrEquals(int n) {
        return this.all.subList(0, this.getPos(n, true));
    }

    @Override
    public List<V> biggerOrEquals(int n) {
        return this.all.subList(this.getPos(n, false), this.all.size());
    }

    private boolean isSorted() {
        for (int i = 0; i < this.all.size() - 1; ++i) {
            int n;
            int n2 = this.measurer.getMeasure(this.all.get(i));
            if (n2 <= (n = this.measurer.getMeasure(this.all.get(i + 1)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<V> iterator() {
        return this.all.iterator();
    }

    static class NullableAndEvenMeasurer<V>
    implements Measurer<V> {
        private final Measurer<V> wrapped;
        private final int valueForNull;

        NullableAndEvenMeasurer(Measurer<V> measurer, int n, boolean bl) {
            this.wrapped = measurer;
            this.valueForNull = bl ? n * 2 + 1 : n * 2 - 1;
        }

        @Override
        public int getMeasure(V v) {
            if (v == null) {
                return this.valueForNull;
            }
            return this.wrapped.getMeasure(v) * 2;
        }
    }
}

