/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.EnumSet;
import java.util.regex.Matcher;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.ugraphic.UFont;

public enum FontStyle {
    PLAIN,
    ITALIC,
    BOLD,
    UNDERLINE,
    STRIKE,
    WAVE,
    BACKCOLOR;


    public UFont mutateFont(UFont uFont) {
        if (this == ITALIC) {
            return uFont.deriveStyle(uFont.getStyle() | 2);
        }
        if (this == BOLD) {
            return uFont.deriveStyle(uFont.getStyle() | 1);
        }
        return uFont;
    }

    public String getActivationPattern() {
        if (this == ITALIC) {
            return "\\<[iI]\\>";
        }
        if (this == BOLD) {
            return "\\<[bB]\\>";
        }
        if (this == UNDERLINE) {
            return "\\<[uU](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        if (this == WAVE) {
            return "\\<[wW](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        if (this == BACKCOLOR) {
            return "\\<[bB][aA][cC][kK](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        if (this == STRIKE) {
            return "\\<(?:s|S|strike|STRIKE|del|DEL)(?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        return null;
    }

    public boolean canHaveExtendedColor() {
        if (this == UNDERLINE) {
            return true;
        }
        if (this == WAVE) {
            return true;
        }
        if (this == BACKCOLOR) {
            return true;
        }
        return this == STRIKE;
    }

    public String getCreoleSyntax() {
        if (this == ITALIC) {
            return "//";
        }
        if (this == BOLD) {
            return "\\*\\*";
        }
        if (this == UNDERLINE) {
            return "__";
        }
        if (this == WAVE) {
            return "~~";
        }
        if (this == STRIKE) {
            return "--";
        }
        throw new UnsupportedOperationException();
    }

    public HtmlColor getExtendedColor(String string) {
        Matcher matcher = MyPattern.cmpile(this.getActivationPattern()).matcher(string);
        if (!matcher.find() || matcher.groupCount() != 1) {
            return null;
        }
        String string2 = matcher.group(1);
        if (HtmlColorSet.getInstance().getColorIfValid(string2) != null) {
            return HtmlColorSet.getInstance().getColorIfValid(string2);
        }
        return null;
    }

    public String getDeactivationPattern() {
        if (this == ITALIC) {
            return "\\</[iI]\\>";
        }
        if (this == BOLD) {
            return "\\</[bB]\\>";
        }
        if (this == UNDERLINE) {
            return "\\</[uU]\\>";
        }
        if (this == WAVE) {
            return "\\</[wW]\\>";
        }
        if (this == BACKCOLOR) {
            return "\\</[bB][aA][cC][kK]\\>";
        }
        if (this == STRIKE) {
            return "\\</(?:s|S|strike|STRIKE|del|DEL)\\>";
        }
        return null;
    }

    public static FontStyle getStyle(String string) {
        for (FontStyle fontStyle : EnumSet.allOf(FontStyle.class)) {
            if (fontStyle == PLAIN || !string.matches(fontStyle.getActivationPattern()) && !string.matches(fontStyle.getDeactivationPattern())) continue;
            return fontStyle;
        }
        throw new IllegalArgumentException(string);
    }
}

