/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.FontChange;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlCommand;
import net.sourceforge.plantuml.graphic.Img;
import net.sourceforge.plantuml.graphic.Line;
import net.sourceforge.plantuml.graphic.Splitter;
import net.sourceforge.plantuml.graphic.SpriteCommand;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.Text;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextLink;
import net.sourceforge.plantuml.graphic.TileText;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class SingleLine
implements Line {
    private final List<TextBlock> blocs = new ArrayList<TextBlock>();
    private final HorizontalAlignment horizontalAlignment;

    public SingleLine(String string, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer) {
        if (string.length() == 0) {
            string = " ";
        }
        this.horizontalAlignment = horizontalAlignment;
        Splitter splitter = new Splitter(string);
        for (HtmlCommand htmlCommand : splitter.getHtmlCommands(false)) {
            Object object;
            if (htmlCommand instanceof Text) {
                object = ((Text)htmlCommand).getText();
                this.blocs.add(new TileText((String)object, fontConfiguration, null));
                continue;
            }
            if (htmlCommand instanceof TextLink) {
                object = ((TextLink)htmlCommand).getText();
                Url url = ((TextLink)htmlCommand).getUrl();
                this.blocs.add(new TileText((String)object, fontConfiguration, url));
                continue;
            }
            if (htmlCommand instanceof Img) {
                this.blocs.add(((Img)htmlCommand).createMonoImage());
                continue;
            }
            if (htmlCommand instanceof SpriteCommand) {
                object = spriteContainer.getSprite(((SpriteCommand)htmlCommand).getSprite());
                if (object == null) continue;
                this.blocs.add(object.asTextBlock(fontConfiguration.getColor()));
                continue;
            }
            if (!(htmlCommand instanceof FontChange)) continue;
            fontConfiguration = ((FontChange)htmlCommand).apply(fontConfiguration);
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = 0.0;
        double d2 = 0.0;
        for (TextBlock textBlock : this.blocs) {
            Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
            d += dimension2D.getWidth();
            d2 = Math.max(d2, dimension2D.getHeight());
        }
        return new Dimension2DDouble(d, d2);
    }

    private double maxDeltaY(UGraphic uGraphic) {
        double d = 0.0;
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        for (TextBlock textBlock : this.blocs) {
            if (!(textBlock instanceof TileText)) continue;
            Dimension2D dimension2D2 = textBlock.calculateDimension(uGraphic.getStringBounder());
            double d2 = dimension2D.getHeight() - dimension2D2.getHeight() + ((TileText)textBlock).getFontSize2D();
            d = Math.max(d, d2);
        }
        return d;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        double d = this.maxDeltaY(uGraphic);
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        double d2 = 0.0;
        for (TextBlock textBlock : this.blocs) {
            if (textBlock instanceof TileText) {
                textBlock.drawU(uGraphic.apply(new UTranslate(d2, d)));
            } else {
                double d3 = dimension2D.getHeight() - textBlock.calculateDimension(stringBounder).getHeight();
                textBlock.drawU(uGraphic.apply(new UTranslate(d2, d3)));
            }
            d2 += textBlock.calculateDimension(stringBounder).getWidth();
        }
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }
}

