/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.FontChange;
import net.sourceforge.plantuml.graphic.FontConfiguration;

class SizeChange
implements FontChange {
    private static final Pattern sizePattern = MyPattern.cmpile("(?i)\\<size[\\s:]+(\\d+)[%s]*\\>");
    private final Integer size;

    SizeChange(String string) {
        Matcher matcher = sizePattern.matcher(string);
        if (!matcher.find()) {
            throw new IllegalArgumentException();
        }
        this.size = new Integer(matcher.group(1));
    }

    Integer getSize() {
        return this.size;
    }

    @Override
    public FontConfiguration apply(FontConfiguration fontConfiguration) {
        return fontConfiguration.changeSize(this.size.intValue());
    }
}

