/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class SymbolContext {
    private final HtmlColor backColor;
    private final HtmlColor foreColor;
    private final UStroke stroke;
    private final boolean shadowing;
    private final double deltaShadow;

    private SymbolContext(HtmlColor htmlColor, HtmlColor htmlColor2, UStroke uStroke, boolean bl, double d) {
        this.backColor = htmlColor;
        this.foreColor = htmlColor2;
        this.stroke = uStroke;
        this.shadowing = bl;
        this.deltaShadow = d;
    }

    public String toString() {
        return super.toString() + " backColor=" + this.backColor + " foreColor=" + this.foreColor;
    }

    public final UGraphic apply(UGraphic uGraphic) {
        return this.applyStroke(this.applyColors(uGraphic));
    }

    public UGraphic applyColors(UGraphic uGraphic) {
        return uGraphic.apply(new UChangeColor(this.foreColor)).apply(new UChangeBackColor(this.backColor));
    }

    public UGraphic applyStroke(UGraphic uGraphic) {
        return uGraphic.apply(this.stroke);
    }

    public SymbolContext(HtmlColor htmlColor, HtmlColor htmlColor2) {
        this(htmlColor, htmlColor2, new UStroke(), false, 0.0);
    }

    public SymbolContext withShadow(boolean bl) {
        return new SymbolContext(this.backColor, this.foreColor, this.stroke, bl, this.deltaShadow);
    }

    public SymbolContext withDeltaShadow(double d) {
        return new SymbolContext(this.backColor, this.foreColor, this.stroke, this.shadowing, d);
    }

    public SymbolContext withStroke(UStroke uStroke) {
        return new SymbolContext(this.backColor, this.foreColor, uStroke, this.shadowing, this.deltaShadow);
    }

    public SymbolContext withBackColor(HtmlColor htmlColor) {
        return new SymbolContext(htmlColor, this.foreColor, this.stroke, this.shadowing, this.deltaShadow);
    }

    public HtmlColor getBackColor() {
        return this.backColor;
    }

    public HtmlColor getForeColor() {
        return this.foreColor;
    }

    public UStroke getStroke() {
        return this.stroke;
    }

    public boolean isShadowing() {
        return this.shadowing || this.deltaShadow > 0.0;
    }

    public double getDeltaShadow() {
        return this.deltaShadow;
    }
}

