/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextBlockArrow
implements TextBlock {
    private final double size;
    private final Direction arrow;
    private final HtmlColor color;

    public TextBlockArrow(Direction direction, FontConfiguration fontConfiguration) {
        if (direction == null) {
            throw new IllegalArgumentException();
        }
        this.arrow = direction;
        this.size = fontConfiguration.getFont().getSize2D();
        this.color = fontConfiguration.getColor();
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UChangeBackColor(this.color));
        uGraphic = uGraphic.apply(new UChangeColor(this.color));
        int n = (int)(this.size * 0.8 - 3.0);
        if (n % 2 == 1) {
            --n;
        }
        UPolygon uPolygon = this.getTriangle(n);
        if (this.arrow == Direction.RIGHT || this.arrow == Direction.LEFT) {
            uGraphic.apply(new UTranslate(2.0, this.size - (double)n - 2.0)).draw(uPolygon);
        } else {
            uGraphic.apply(new UTranslate(2.0, this.size - (double)n - 2.0)).draw(uPolygon);
        }
    }

    private UPolygon getTriangle(int n) {
        UPolygon uPolygon = new UPolygon();
        if (this.arrow == Direction.RIGHT) {
            uPolygon.addPoint(0.0, 0.0);
            uPolygon.addPoint(n, n / 2);
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(0.0, 0.0);
        } else if (this.arrow == Direction.LEFT) {
            uPolygon.addPoint(n, 0.0);
            uPolygon.addPoint(0.0, n / 2);
            uPolygon.addPoint(n, n);
            uPolygon.addPoint(n, 0.0);
        } else if (this.arrow == Direction.UP) {
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(n / 2, 0.0);
            uPolygon.addPoint(n, n);
            uPolygon.addPoint(0.0, n);
        } else if (this.arrow == Direction.DOWN) {
            uPolygon.addPoint(0.0, 0.0);
            uPolygon.addPoint(n / 2, n);
            uPolygon.addPoint(n, 0.0);
            uPolygon.addPoint(0.0, 0.0);
        } else {
            throw new IllegalStateException();
        }
        return uPolygon;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.size, this.size);
    }
}

