/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class TextBlockMinWidth
implements TextBlock {
    private final TextBlock textBlock;
    private final double minWidth;
    private final HorizontalAlignment horizontalAlignment;

    public TextBlockMinWidth(TextBlock textBlock, double d, HorizontalAlignment horizontalAlignment) {
        this.textBlock = textBlock;
        this.minWidth = d;
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        return Dimension2DDouble.atLeast(dimension2D, this.minWidth, 0.0);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
            this.textBlock.drawU(uGraphic);
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
            Dimension2D dimension2D = this.textBlock.calculateDimension(uGraphic.getStringBounder());
            double d = this.minWidth - dimension2D.getWidth();
            this.textBlock.drawU(uGraphic.apply(new UTranslate(d, 0.0)));
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

