/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockHorizontal;
import net.sourceforge.plantuml.graphic.TextBlockMarged;
import net.sourceforge.plantuml.graphic.TextBlockMinWidth;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.graphic.TextBlockSpotted;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableImpl;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class TextBlockUtils {
    private static final Graphics2D gg;
    private static final StringBounder dummyStringBounder;

    public static TextBlock create(Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple) {
        return TextBlockUtils.create(display, fontConfiguration, horizontalAlignment, iSkinSimple, false);
    }

    public static TextBlock create(Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, boolean bl) {
        if (display == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        return TextBlockUtils.create(display, fontConfiguration, horizontalAlignment, iSkinSimple, 0.0, bl, null, null);
    }

    public static TextBlock create(Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, double d, boolean bl, UFont uFont, HtmlColor htmlColor) {
        if (display.getNaturalHorizontalAlignment() != null) {
            horizontalAlignment = display.getNaturalHorizontalAlignment();
        }
        if (display.size() > 0) {
            if (display.get(0) instanceof Stereotype) {
                return TextBlockUtils.createStereotype(display, fontConfiguration, horizontalAlignment, iSkinSimple, 0, uFont, htmlColor);
            }
            if (display.get(display.size() - 1) instanceof Stereotype) {
                return TextBlockUtils.createStereotype(display, fontConfiguration, horizontalAlignment, iSkinSimple, display.size() - 1, uFont, htmlColor);
            }
            if (display.get(0) instanceof MessageNumber) {
                return TextBlockUtils.createMessageNumber(display, fontConfiguration, horizontalAlignment, iSkinSimple, d);
            }
        }
        return TextBlockUtils.getCreole(display, fontConfiguration, horizontalAlignment, iSkinSimple, d, bl);
    }

    private static TextBlock getCreole(Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, double d, boolean bl) {
        Sheet sheet = new CreoleParser(fontConfiguration, horizontalAlignment, iSkinSimple, bl).createSheet(display);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, d, iSkinSimple == null ? 0.0 : iSkinSimple.getPadding());
        return new SheetBlock2(sheetBlock1, sheetBlock1, new UStroke(1.5));
    }

    private static TextBlock createMessageNumber(Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, double d) {
        TextBlock textBlock = TextBlockUtils.getCreole(display.subList(0, 1), fontConfiguration, horizontalAlignment, iSkinSimple, d, false);
        textBlock = TextBlockUtils.withMargin(textBlock, 0.0, 4.0, 0.0, 0.0);
        TextBlock textBlock2 = TextBlockUtils.getCreole(display.subList(1, display.size()), fontConfiguration, horizontalAlignment, iSkinSimple, d, false);
        return TextBlockUtils.mergeLR(textBlock, textBlock2, VerticalAlignment.CENTER);
    }

    private static TextBlock createStereotype(Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer, int n, UFont uFont, HtmlColor htmlColor) {
        Stereotype stereotype = (Stereotype)display.get(n);
        if (stereotype.isSpotted()) {
            CircledCharacter circledCharacter = new CircledCharacter(stereotype.getCharacter(), stereotype.getRadius(), stereotype.getCircledFont(), stereotype.getHtmlColor(), null, fontConfiguration.getColor());
            if (stereotype.getLabel(false) == null) {
                return new TextBlockSpotted(circledCharacter, display.subList(1, display.size()), fontConfiguration, horizontalAlignment, spriteContainer);
            }
            return new TextBlockSpotted(circledCharacter, display, fontConfiguration, horizontalAlignment, spriteContainer);
        }
        return new TextBlockSimple(display, fontConfiguration, horizontalAlignment, spriteContainer, 0.0, uFont, htmlColor);
    }

    public static TextBlock withMargin(TextBlock textBlock, double d, double d2) {
        return new TextBlockMarged(textBlock, d, d, d2, d2);
    }

    public static TextBlock withMinWidth(TextBlock textBlock, double d, HorizontalAlignment horizontalAlignment) {
        return new TextBlockMinWidth(textBlock, d, horizontalAlignment);
    }

    public static TextBlock withMargin(TextBlock textBlock, double d, double d2, double d3, double d4) {
        return new TextBlockMarged(textBlock, d, d2, d3, d4);
    }

    public static TextBlock empty(final double d, final double d2) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }
        };
    }

    public static Positionable asPositionable(TextBlock textBlock, StringBounder stringBounder, Point2D point2D) {
        return new PositionableImpl(point2D, textBlock.calculateDimension(stringBounder));
    }

    public static TextBlock mergeLR(TextBlock textBlock, TextBlock textBlock2, VerticalAlignment verticalAlignment) {
        return new TextBlockHorizontal(textBlock, textBlock2, verticalAlignment);
    }

    public static TextBlock mergeTB(TextBlock textBlock, TextBlock textBlock2, HorizontalAlignment horizontalAlignment) {
        return new TextBlockVertical2(textBlock, textBlock2, horizontalAlignment);
    }

    public static MinMax getMinMax(TextBlock textBlock, StringBounder stringBounder) {
        LimitFinder limitFinder = new LimitFinder(stringBounder, false);
        textBlock.drawU(limitFinder);
        return limitFinder.getMinMax();
    }

    public static StringBounder getDummyStringBounder() {
        return dummyStringBounder;
    }

    public static FontRenderContext getFontRenderContext() {
        return gg.getFontRenderContext();
    }

    public static MinMax getMinMax(TextBlock textBlock) {
        return TextBlockUtils.getMinMax(textBlock, dummyStringBounder);
    }

    public static Dimension2D getDimension(TextBlock textBlock) {
        return textBlock.calculateDimension(dummyStringBounder);
    }

    public static LineMetrics getLineMetrics(UFont uFont, String string) {
        return uFont.getLineMetrics(gg, string);
    }

    public static FontMetrics getFontMetrics(Font font) {
        return gg.getFontMetrics(font);
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        gg = bufferedImage.createGraphics();
        dummyStringBounder = StringBounderUtils.asStringBounder(gg);
    }
}

