/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolArtifact
extends USymbol {
    USymbolArtifact() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.ARTIFACT;
    }

    private void drawArtifact(UGraphic uGraphic, double d, double d2, boolean bl) {
        URectangle uRectangle = new URectangle(d, d2);
        if (bl) {
            uRectangle.setDeltaShadow(4.0);
        }
        uGraphic.draw(uRectangle);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, 14.0);
        uPolygon.addPoint(12.0, 14.0);
        uPolygon.addPoint(12.0, 6.0);
        uPolygon.addPoint(6.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        double d3 = d - 12.0 - 5.0;
        uGraphic.apply(new UTranslate(d3, 5.0)).draw(uPolygon);
        uGraphic.apply(new UTranslate(d3 + 12.0 - 6.0, 5.0)).draw(new ULine(0.0, 6.0));
        uGraphic.apply(new UTranslate(d3 + 12.0, 11.0)).draw(new ULine(-6.0, 0.0));
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 20.0, 13.0, 10.0);
    }

    @Override
    public TextBlock asSmall(final TextBlock textBlock, final TextBlock textBlock2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolArtifact.this.drawArtifact(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolArtifact.this.getMargin();
                TextBlock textBlock3 = TextBlockUtils.mergeTB(textBlock2, textBlock, HorizontalAlignment.CENTER);
                textBlock3.drawU(uGraphic.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock2.calculateDimension(stringBounder);
                return USymbolArtifact.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock textBlock, final TextBlock textBlock2, final double d, final double d2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolArtifact.this.drawArtifact(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                Dimension2D dimension2D2 = textBlock2.calculateDimension(uGraphic.getStringBounder());
                double d3 = (d - dimension2D2.getWidth()) / 2.0;
                textBlock2.drawU(uGraphic.apply(new UTranslate(d3, 2.0)));
                Dimension2D dimension2D3 = textBlock.calculateDimension(uGraphic.getStringBounder());
                double d22 = (d - dimension2D3.getWidth()) / 2.0;
                textBlock.drawU(uGraphic.apply(new UTranslate(d22, 2.0 + dimension2D2.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }
        };
    }
}

