/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolCloud
extends USymbol {
    USymbolCloud() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.CLOUD;
    }

    private void drawCloud(UGraphic uGraphic, double d, double d2, boolean bl) {
        UPath uPath = this.getSpecificFrontierForCloud(d, d2);
        if (bl) {
            uPath.setDeltaShadow(3.0);
        }
        uGraphic.apply(new UTranslate(3.0, -3.0)).draw(uPath);
    }

    private UPath getSpecificFrontierForCloud(double d, double d2) {
        UPath uPath = new UPath();
        uPath.moveTo(0.0, 10.0);
        double d3 = 0.0;
        int n = 0;
        while ((double)n < d - 9.0) {
            uPath.cubicTo(n, 7.0, 2 + n, 5.0, 5 + n, 5.0);
            uPath.cubicTo(8 + n, 5.0, 10 + n, 7.0, 10 + n, 10.0);
            d3 = n + 10;
            n += 10;
        }
        double d4 = 0.0;
        int n2 = 10;
        while ((double)n2 < d2 - 9.0) {
            uPath.cubicTo(d3 + 3.0, n2, d3 + 5.0, 2 + n2, d3 + 5.0, 5 + n2);
            uPath.cubicTo(d3 + 5.0, 8 + n2, d3 + 3.0, 10 + n2, d3, 10 + n2);
            d4 = n2 + 10;
            n2 += 10;
        }
        n2 = 0;
        while ((double)n2 < d - 9.0) {
            uPath.cubicTo(d3 - (double)n2, d4 + 3.0, d3 - 3.0 - (double)n2, d4 + 5.0, d3 - 5.0 - (double)n2, d4 + 5.0);
            uPath.cubicTo(d3 - 8.0 - (double)n2, d4 + 5.0, d3 - 10.0 - (double)n2, d4 + 3.0, d3 - 10.0 - (double)n2, d4);
            n2 += 10;
        }
        n2 = 0;
        while ((double)n2 < d2 - 9.0 - 10.0) {
            uPath.cubicTo(-3.0, d4 - (double)n2, -5.0, d4 - 2.0 - (double)n2, -5.0, d4 - 5.0 - (double)n2);
            uPath.cubicTo(-5.0, d4 - 8.0 - (double)n2, -3.0, d4 - 10.0 - (double)n2, 0.0, d4 - 10.0 - (double)n2);
            n2 += 10;
        }
        return uPath;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(final TextBlock textBlock, final TextBlock textBlock2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolCloud.this.drawCloud(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolCloud.this.getMargin();
                TextBlock textBlock3 = TextBlockUtils.mergeTB(textBlock2, textBlock, HorizontalAlignment.CENTER);
                textBlock3.drawU(uGraphic.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock2.calculateDimension(stringBounder);
                return USymbolCloud.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock textBlock, final TextBlock textBlock2, final double d, final double d2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolCloud.this.drawCloud(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                Dimension2D dimension2D2 = textBlock2.calculateDimension(uGraphic.getStringBounder());
                double d3 = (d - dimension2D2.getWidth()) / 2.0;
                textBlock2.drawU(uGraphic.apply(new UTranslate(d3, 13.0)));
                Dimension2D dimension2D3 = textBlock.calculateDimension(uGraphic.getStringBounder());
                double d22 = (d - dimension2D3.getWidth()) / 2.0;
                textBlock.drawU(uGraphic.apply(new UTranslate(d22, 13.0 + dimension2D2.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }
        };
    }
}

