/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphicHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolQueue
extends USymbol {
    private final double dx = 5.0;

    USymbolQueue() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.QUEUE;
    }

    private void drawDatabase(UGraphic uGraphic, double d, double d2, boolean bl) {
        UPath uPath = new UPath();
        if (bl) {
            uPath.setDeltaShadow(3.0);
        }
        uPath.moveTo(5.0, 0.0);
        uPath.lineTo(d - 5.0, 0.0);
        uPath.cubicTo(d, 0.0, d, d2 / 2.0, d, d2 / 2.0);
        uPath.cubicTo(d, d2 / 2.0, d, d2, d - 5.0, d2);
        uPath.lineTo(5.0, d2);
        uPath.cubicTo(0.0, d2, 0.0, d2 / 2.0, 0.0, d2 / 2.0);
        uPath.cubicTo(0.0, d2 / 2.0, 0.0, 0.0, 5.0, 0.0);
        uGraphic.draw(uPath);
        UPath uPath2 = this.getClosingPath(d, d2);
        uGraphic.apply(new UChangeBackColor(null)).draw(uPath2);
    }

    private UPath getClosingPath(double d, double d2) {
        UPath uPath = new UPath();
        uPath.moveTo(d - 5.0, 0.0);
        uPath.cubicTo(d - 10.0, 0.0, d - 10.0, d2 / 2.0, d - 10.0, d2 / 2.0);
        uPath.cubicTo(d - 10.0, d2, d - 5.0, d2, d - 5.0, d2);
        return uPath;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(5.0, 15.0, 5.0, 5.0);
    }

    @Override
    public TextBlock asSmall(final TextBlock textBlock, final TextBlock textBlock2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolQueue.this.drawDatabase(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolQueue.this.getMargin();
                TextBlock textBlock3 = TextBlockUtils.mergeTB(textBlock2, textBlock, HorizontalAlignment.CENTER);
                MyUGraphicDatabase myUGraphicDatabase = new MyUGraphicDatabase(uGraphic, dimension2D.getWidth());
                textBlock3.drawU(myUGraphicDatabase.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock2.calculateDimension(stringBounder);
                return USymbolQueue.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }
        };
    }

    @Override
    public TextBlock asBig(TextBlock textBlock, TextBlock textBlock2, double d, double d2, SymbolContext symbolContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean manageHorizontalLine() {
        return true;
    }

    class MyUGraphicDatabase
    extends AbstractUGraphicHorizontalLine {
        private final double endingX;

        @Override
        protected AbstractUGraphicHorizontalLine copy(UGraphic uGraphic) {
            return new MyUGraphicDatabase(uGraphic, this.endingX);
        }

        public MyUGraphicDatabase(UGraphic uGraphic, double d) {
            super(uGraphic);
            this.endingX = d;
        }

        @Override
        protected void drawHline(UGraphic uGraphic, UHorizontalLine uHorizontalLine, UTranslate uTranslate) {
            uHorizontalLine.drawTitleInternal(uGraphic, 0.0, this.endingX, 0.0, true);
        }
    }
}

