/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.hector.Pin;
import net.sourceforge.plantuml.hector.PinFactory;
import net.sourceforge.plantuml.hector.PinLink;
import net.sourceforge.plantuml.hector.Skeleton;
import net.sourceforge.plantuml.hector.SkeletonBuilder;
import net.sourceforge.plantuml.hector.SkeletonConfiguration;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CucaDiagramFileMakerHector3
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private SkeletonConfiguration configuration;
    private double singleWidth;
    private double singleHeight;
    private double nodeMargin = 40.0;
    private final Map<Pin, IEntityImage> images = new LinkedHashMap<Pin, IEntityImage>();
    private final Map<Link, PinLink> links = new LinkedHashMap<Link, PinLink>();

    public CucaDiagramFileMakerHector3(CucaDiagram cucaDiagram) {
        this.diagram = cucaDiagram;
    }

    private double getX(Pin pin) {
        return this.singleWidth * (double)this.configuration.getCol(pin);
    }

    private double getY(Pin pin) {
        return this.singleHeight * (double)pin.getRow();
    }

    private double getCenterX(Pin pin) {
        return this.singleWidth * (double)this.configuration.getCol(pin) + this.singleWidth / 2.0;
    }

    private double getCenterY(Pin pin) {
        return this.singleHeight * (double)pin.getRow() + this.singleHeight / 2.0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImageData createFile(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException {
        void var7_10;
        Object object;
        Object object2;
        PinFactory pinFactory = new PinFactory();
        SkeletonBuilder skeletonBuilder = new SkeletonBuilder();
        for (Link object32 : this.diagram.getLinks()) {
            PinLink pinLink = pinFactory.createPinLink(object32);
            this.links.put(object32, pinLink);
            skeletonBuilder.add(pinLink);
        }
        Skeleton skeleton = skeletonBuilder.createSkeletons().get(0);
        this.configuration = SkeletonConfiguration.getDefault(skeleton);
        this.singleWidth = 0.0;
        this.singleHeight = 0.0;
        for (Pin pin : skeleton.getPins()) {
            ILeaf iLeaf = (ILeaf)pin.getUserData();
            object2 = this.computeImage(iLeaf);
            object = TextBlockUtils.getDimension((TextBlock)object2);
            if (((Dimension2D)object).getWidth() > this.singleWidth) {
                this.singleWidth = ((Dimension2D)object).getWidth();
            }
            if (((Dimension2D)object).getHeight() > this.singleHeight) {
                this.singleHeight = ((Dimension2D)object).getHeight();
            }
            this.images.put(pin, (IEntityImage)object2);
        }
        this.singleHeight += this.nodeMargin;
        this.singleWidth += this.nodeMargin;
        MinMax minMax = MinMax.getEmpty(false);
        for (Pin pin : skeleton.getPins()) {
            MinMax minMax3 = var7_10.addPoint(this.getX(pin), this.getY(pin));
            minMax3 = minMax3.addPoint(this.getX(pin) + this.singleWidth, this.getY(pin) + this.singleHeight);
        }
        object2 = new Dimension2DDouble(20.0 + var7_10.getMaxX(), 20.0 + var7_10.getMaxY());
        object = null;
        object = (UGraphic2)object.apply(new UTranslate(10.0, 10.0));
        for (PinLink pinLink : skeleton.getPinLinks()) {
            this.drawPinLink((UGraphic)object, pinLink);
        }
        for (Map.Entry entry : this.images.entrySet()) {
            Pin pin = (Pin)entry.getKey();
            IEntityImage iEntityImage = (IEntityImage)entry.getValue();
            double d = this.getX(pin);
            double d2 = this.getY(pin);
            Dimension2D dimension2D = iEntityImage.calculateDimension(object.getStringBounder());
            iEntityImage.drawU(object.apply(new UTranslate(d + (this.singleWidth - dimension2D.getWidth()) / 2.0, d2 + (this.singleHeight - dimension2D.getHeight()) / 2.0)));
        }
        throw new UnsupportedOperationException();
    }

    private void drawPinLink(UGraphic uGraphic, PinLink pinLink) {
        Rose rose = new Rose();
        HtmlColor htmlColor = rose.getHtmlColor(this.diagram.getSkinParam(), ColorParam.classArrow);
        uGraphic = uGraphic.apply(new UChangeColor(htmlColor)).apply(new UStroke(1.5));
        double d = this.getCenterX(pinLink.getPin1());
        double d2 = this.getCenterY(pinLink.getPin1());
        double d3 = this.getCenterX(pinLink.getPin2());
        double d4 = this.getCenterY(pinLink.getPin2());
        uGraphic = uGraphic.apply(new UTranslate(d, d2));
        uGraphic.draw(new ULine(d3 - d, d4 - d2));
    }

    private IEntityImage computeImage(ILeaf iLeaf) {
        IEntityImage iEntityImage = CucaDiagramFileMakerSvek2.createEntityImageBlock(iLeaf, this.diagram.getSkinParam(), false, this.diagram, null, null, null);
        return iEntityImage;
    }
}

