/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.hector.Box2D;
import net.sourceforge.plantuml.hector.Pin;
import net.sourceforge.plantuml.hector.PinFactory;
import net.sourceforge.plantuml.hector.PinLink;
import net.sourceforge.plantuml.hector.Skeleton;
import net.sourceforge.plantuml.hector.SkeletonBuilder;
import net.sourceforge.plantuml.hector.SkeletonConfiguration;
import net.sourceforge.plantuml.hector.SkeletonConfigurationUtils;
import net.sourceforge.plantuml.hector.SmartConnection;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CucaDiagramFileMakerHectorB1
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private SkeletonConfiguration configuration;
    private double nodeMargin = 40.0;
    private final Map<Link, PinLink> links = new LinkedHashMap<Link, PinLink>();

    public CucaDiagramFileMakerHectorB1(CucaDiagram cucaDiagram) {
        this.diagram = cucaDiagram;
    }

    private double getX(Pin pin) {
        return this.nodeMargin * (double)this.configuration.getCol(pin);
    }

    private double getY(Pin pin) {
        return this.nodeMargin * (double)pin.getRow();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImageData createFile(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException {
        void var7_9;
        PinFactory pinFactory = new PinFactory();
        SkeletonBuilder skeletonBuilder = new SkeletonBuilder();
        this.links.clear();
        for (Link object2 : this.diagram.getLinks()) {
            PinLink pinLink = pinFactory.createPinLink(object2);
            this.links.put(object2, pinLink);
            skeletonBuilder.add(pinLink);
        }
        Skeleton skeleton = skeletonBuilder.createSkeletons().get(0);
        this.configuration = SkeletonConfigurationUtils.getBest(skeleton);
        MinMax minMax = MinMax.getEmpty(false);
        for (Pin pin : skeleton.getPins()) {
            MinMax minMax2 = var7_9.addPoint(this.getX(pin), this.getY(pin));
        }
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(20.0 + var7_9.getMaxX(), 20.0 + var7_9.getMaxY());
        UGraphic uGraphic = null;
        uGraphic = (UGraphic2)uGraphic.apply(new UTranslate(10.0, 10.0));
        for (PinLink pinLink : skeleton.getPinLinks()) {
            this.drawPinLink(uGraphic, pinLink);
        }
        for (Pin pin : skeleton.getPins()) {
            this.drawPin(uGraphic, pin);
        }
        throw new UnsupportedOperationException();
    }

    private void drawPin(UGraphic uGraphic, Pin pin) {
        double d = this.getX(pin);
        double d2 = this.getY(pin);
        UEllipse uEllipse = new UEllipse(6.0, 6.0);
        uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UChangeBackColor(HtmlColorUtils.BLACK)).apply(new UTranslate(d - 3.0, d2 - 3.0)).draw(uEllipse);
    }

    private void drawPinLink(UGraphic uGraphic, PinLink pinLink) {
        double d = this.getX(pinLink.getPin1());
        double d2 = this.getY(pinLink.getPin1());
        double d3 = this.getX(pinLink.getPin2());
        double d4 = this.getY(pinLink.getPin2());
        Rose rose = new Rose();
        HtmlColor htmlColor = rose.getHtmlColor(this.diagram.getSkinParam(), ColorParam.classArrow);
        ArrayList<Box2D> arrayList = new ArrayList<Box2D>();
        SmartConnection smartConnection = new SmartConnection(d, d2, d3, d4, arrayList);
        smartConnection.draw(uGraphic, htmlColor);
    }

    private IEntityImage computeImage(ILeaf iLeaf) {
        IEntityImage iEntityImage = CucaDiagramFileMakerSvek2.createEntityImageBlock(iLeaf, this.diagram.getSkinParam(), false, this.diagram, null, null, null);
        return iEntityImage;
    }
}

