/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.hector.PinLink;
import net.sourceforge.plantuml.hector.PinLinksContinuousSet;
import net.sourceforge.plantuml.hector.Skeleton;

public class SkeletonBuilder {
    private List<PinLinksContinuousSet> sets = new ArrayList<PinLinksContinuousSet>();

    public void add(PinLink pinLink) {
        this.addInternal(pinLink);
        this.merge();
    }

    private void merge() {
        for (int i = 0; i < this.sets.size() - 1; ++i) {
            for (int j = i + 1; j < this.sets.size(); ++j) {
                if (!this.sets.get(i).doesTouch(this.sets.get(j))) continue;
                this.sets.get(i).addAll(this.sets.get(j));
                this.sets.remove(j);
                return;
            }
        }
    }

    private void addInternal(PinLink pinLink) {
        for (PinLinksContinuousSet pinLinksContinuousSet : this.sets) {
            if (!pinLinksContinuousSet.doesTouch(pinLink)) continue;
            pinLinksContinuousSet.add(pinLink);
            return;
        }
        PinLinksContinuousSet pinLinksContinuousSet = new PinLinksContinuousSet();
        pinLinksContinuousSet.add(pinLink);
        this.sets.add(pinLinksContinuousSet);
    }

    public List<Skeleton> createSkeletons() {
        ArrayList<Skeleton> arrayList = new ArrayList<Skeleton>();
        for (PinLinksContinuousSet pinLinksContinuousSet : this.sets) {
            arrayList.add(pinLinksContinuousSet.createSkeleton());
        }
        return Collections.unmodifiableList(arrayList);
    }
}

