/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import net.sourceforge.plantuml.hector.Pin;
import net.sourceforge.plantuml.hector.PinLink;
import net.sourceforge.plantuml.hector.Skeleton;
import net.sourceforge.plantuml.hector.SkeletonMutation;

public class SkeletonConfiguration {
    private final int[] position;
    private final Skeleton skeleton;

    public static SkeletonConfiguration getDefault(Skeleton skeleton) {
        SortedSet<Integer> sortedSet = skeleton.getRows();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (Integer object2 : sortedSet) {
            hashMap.put(object2, 0);
        }
        List<Pin> list = skeleton.getPins();
        int[] nArray = new int[list.size()];
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n;
            Pin pin = (Pin)iterator.next();
            nArray[pin.getUid()] = n = ((Integer)hashMap.get(pin.getRow())).intValue();
            hashMap.put(pin.getRow(), n + 1);
        }
        return new SkeletonConfiguration(skeleton, nArray);
    }

    public int hashCode() {
        int n = 0;
        for (int n2 : this.position) {
            n = n * 37 + n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        SkeletonConfiguration skeletonConfiguration = (SkeletonConfiguration)object;
        if (this.skeleton != skeletonConfiguration.skeleton) {
            throw new IllegalArgumentException();
        }
        if (this.position.length != skeletonConfiguration.position.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.position.length; ++i) {
            if (this.position[i] == skeletonConfiguration.position[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n = this.skeleton.getRows().first();
        int n2 = this.skeleton.getRows().last();
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int n5 : this.position) {
            if (n5 > n4) {
                n4 = n5;
            }
            if (n5 >= n3) continue;
            n3 = n5;
        }
        Object object = new StringBuilder();
        for (int i = n; i <= n2; ++i) {
            this.appendRow((StringBuilder)object, i, n3, n4);
            if (i >= n2) continue;
            ((StringBuilder)object).append(" ");
        }
        return ((StringBuilder)object).toString();
    }

    private void appendRow(StringBuilder stringBuilder, int n, int n2, int n3) {
        stringBuilder.append("(");
        boolean bl = true;
        for (int i = n2; i <= n3; ++i) {
            Pin pin;
            if (!bl) {
                stringBuilder.append("-");
            }
            if ((pin = this.getPin(n, i)) == null) {
                stringBuilder.append(".");
            } else {
                stringBuilder.append(pin.getUid());
            }
            bl = false;
        }
        stringBuilder.append(")");
    }

    private Pin getPin(int n, int n2) {
        for (Pin pin : this.skeleton.getPinsOfRow(n)) {
            if (this.getCol(pin) != n2) continue;
            return pin;
        }
        return null;
    }

    public int getCol(Pin pin) {
        return this.position[pin.getUid()];
    }

    private SkeletonConfiguration(Skeleton skeleton, int[] nArray) {
        this.position = nArray;
        this.skeleton = skeleton;
    }

    private Collection<SkeletonMutation> getMutationForRow(int n) {
        Collection<Pin> collection = this.skeleton.getPinsOfRow(n);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Pin object : collection) {
            hashSet.add(this.getCol(object));
        }
        ArrayList arrayList = new ArrayList();
        for (Pin pin : collection) {
            int n2 = this.getCol(pin);
            if (!hashSet.contains(n2 + 1)) {
                arrayList.add(new Move(pin, 1));
            }
            if (!hashSet.contains(n2 - 1)) {
                arrayList.add(new Move(pin, -1));
            }
            for (Pin pin2 : collection) {
                if (pin == pin2 || this.getCol(pin) > this.getCol(pin2)) continue;
                if (this.getCol(pin) == this.getCol(pin2)) {
                    throw new IllegalStateException();
                }
                arrayList.add(new Switch(pin, pin2));
            }
        }
        return arrayList;
    }

    public Set<SkeletonConfiguration> getSomeMuteds() {
        HashSet<SkeletonConfiguration> hashSet = new HashSet<SkeletonConfiguration>();
        for (Integer n : this.skeleton.getRows()) {
            for (SkeletonMutation skeletonMutation : this.getMutationForRow(n)) {
                hashSet.add(skeletonMutation.mutate());
            }
        }
        return hashSet;
    }

    public List<PinLink> getPinLinks() {
        return this.skeleton.getPinLinks();
    }

    public double getLength(PinLink pinLink) {
        double d = this.getCol(pinLink.getPin1());
        double d2 = pinLink.getPin1().getRow();
        double d3 = this.getCol(pinLink.getPin2());
        double d4 = pinLink.getPin2().getRow();
        double d5 = d3 - d;
        double d6 = d4 - d2;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    class Move
    implements SkeletonMutation {
        private final SkeletonConfiguration newConfiguration;

        public Move(Pin pin, int n) {
            int[] nArray = new int[SkeletonConfiguration.this.position.length];
            for (int i = 0; i < SkeletonConfiguration.this.position.length; ++i) {
                nArray[i] = i == pin.getUid() ? SkeletonConfiguration.this.position[i] + n : SkeletonConfiguration.this.position[i];
            }
            this.newConfiguration = new SkeletonConfiguration(SkeletonConfiguration.this.skeleton, nArray);
        }

        @Override
        public SkeletonConfiguration mutate() {
            return this.newConfiguration;
        }
    }

    class Switch
    implements SkeletonMutation {
        private final SkeletonConfiguration newConfiguration;

        public Switch(Pin pin, Pin pin2) {
            if (pin == pin2) {
                throw new IllegalArgumentException();
            }
            int[] nArray = new int[SkeletonConfiguration.this.position.length];
            for (int i = 0; i < SkeletonConfiguration.this.position.length; ++i) {
                nArray[i] = i == pin.getUid() ? SkeletonConfiguration.this.position[pin2.getUid()] : (i == pin2.getUid() ? SkeletonConfiguration.this.position[pin.getUid()] : SkeletonConfiguration.this.position[i]);
            }
            this.newConfiguration = new SkeletonConfiguration(SkeletonConfiguration.this.skeleton, nArray);
        }

        @Override
        public SkeletonConfiguration mutate() {
            return this.newConfiguration;
        }
    }
}

