/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.awt.geom.Point2D;
import java.util.List;
import net.sourceforge.plantuml.geom.LineSegmentDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.hector.Box2D;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UStroke;

class SmartConnection {
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;
    private final List<Box2D> forbidden;

    public SmartConnection(double d, double d2, double d3, double d4, List<Box2D> list) {
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
        this.forbidden = list;
    }

    public SmartConnection(Point2D point2D, Point2D point2D2, List<Box2D> list) {
        this(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), list);
    }

    public void draw(UGraphic uGraphic, HtmlColor htmlColor) {
        LineSegmentDouble lineSegmentDouble = new LineSegmentDouble(this.x1, this.y1, this.x2, this.y2);
        boolean bl = this.intersect(lineSegmentDouble);
        uGraphic = bl ? uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UStroke(1.0)) : uGraphic.apply(new UChangeColor(htmlColor)).apply(new UStroke(1.5));
        lineSegmentDouble.draw(uGraphic);
    }

    private boolean intersect(LineSegmentDouble lineSegmentDouble) {
        for (Box2D box2D : this.forbidden) {
            if (!box2D.doesIntersect(lineSegmentDouble)) continue;
            return true;
        }
        return false;
    }

    public void drawEx1(UGraphic uGraphic, HtmlColor htmlColor) {
        uGraphic = uGraphic.apply(new UChangeColor(htmlColor)).apply(new UStroke(1.5));
        double d = -(this.y2 - this.y1);
        double d2 = this.x2 - this.x1;
        for (int i = -10; i <= 10; ++i) {
            for (int j = -10; j <= 10; ++j) {
                double d3 = d * (double)i / 10.0;
                double d4 = d2 * (double)i / 10.0;
                double d5 = (this.x1 + this.x2) / 2.0 + d3;
                double d6 = (this.y1 + this.y2) / 2.0 + d4;
                double d7 = d * (double)j / 10.0;
                double d8 = d2 * (double)j / 10.0;
                double d9 = (this.x1 + this.x2) / 2.0 + d7;
                double d10 = (this.y1 + this.y2) / 2.0 + d8;
                UPath uPath = new UPath();
                uPath.moveTo(this.x1, this.y1);
                uPath.cubicTo(d5, d6, d9, d10, this.x2, this.y2);
                uGraphic.draw(uPath);
            }
        }
    }
}

