/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

class UnlinearCompression {
    private final double inner;
    private final double outer;

    public UnlinearCompression(double d, double d2) {
        this.inner = d;
        this.outer = d2;
    }

    public double compress(double d) {
        double d2;
        double d3;
        if ((d -= (d3 = Math.floor(d2 = d / (this.inner + this.outer))) * (this.inner + this.outer)) < this.inner) {
            return d3 * this.outer;
        }
        return d - this.inner + d3 * this.outer;
    }

    public double uncompress(double d, Rounding rounding) {
        int n = this.nbOuterBefore(d);
        boolean bl = UnlinearCompression.equals(d, (double)n * this.outer);
        if (!bl || rounding != Rounding.BORDER_1) {
            d = bl && rounding == Rounding.CENTRAL ? (d += this.inner / 2.0) : (d += this.inner);
        }
        return d += (double)n * this.inner;
    }

    private static boolean equals(double d, double d2) {
        return Math.abs(d - d2) < 0.001;
    }

    private int nbOuterBefore(double d) {
        double d2 = d / this.outer;
        int n = (int)Math.floor(d2);
        return n;
    }

    public double[] encounteredSingularities(double d, double d2) {
        double[] dArray;
        int n = this.nbOuterBefore(d) + 1;
        int n2 = this.nbOuterBefore(d2) + 1;
        if (UnlinearCompression.equals(d2, (double)(n2 - 1) * this.outer)) {
            --n2;
        }
        if (d <= d2) {
            dArray = new double[n2 - n];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (double)(n + i) * this.outer;
            }
        } else {
            dArray = new double[n - n2];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (double)(n - 1 - i) * this.outer;
            }
        }
        return dArray;
    }

    public double innerSize() {
        return this.inner;
    }

    static enum Rounding {
        BORDER_1,
        CENTRAL,
        BORDER_2;

    }
}

