/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector2;

import java.util.Collection;

public class MinMax {
    private final int min;
    private final int max;

    private MinMax(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException();
        }
        this.min = n;
        this.max = n2;
    }

    private MinMax(int n) {
        this(n, n);
    }

    public MinMax add(int n) {
        int n2 = Math.min(this.min, n);
        int n3 = Math.max(this.max, n);
        if (this.min == n2 && this.max == n3) {
            return this;
        }
        return new MinMax(n2, n3);
    }

    public MinMax add(MinMax minMax) {
        int n = Math.min(this.min, minMax.min);
        int n2 = Math.max(this.max, minMax.max);
        if (this.min == n && this.max == n2) {
            return this;
        }
        return new MinMax(n, n2);
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    public static MinMax from(Collection<Integer> collection) {
        MinMax minMax = null;
        for (Integer n : collection) {
            if (minMax == null) {
                minMax = new MinMax(n);
                continue;
            }
            minMax = minMax.add(n);
        }
        return minMax;
    }

    public int getDiff() {
        return this.max - this.min;
    }
}

