/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector2.continuity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;

public class Skeleton {
    private final Set<IEntity> entities = new HashSet<IEntity>();
    private final List<Link> links = new ArrayList<Link>();

    private Set<IEntity> getDirectChildren(IEntity iEntity) {
        HashSet<IEntity> hashSet = new HashSet<IEntity>();
        for (Link link : this.links) {
            if (link.isAutolink() || link.getEntity1() != iEntity) continue;
            hashSet.add(link.getEntity2());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public String toString() {
        return "skeleton " + this.links;
    }

    private Set<IEntity> getIndirectChildren(IEntity iEntity) {
        HashSet<IEntity> hashSet = new HashSet<IEntity>(this.getDirectChildren(iEntity));
        int n = hashSet.size();
        while (true) {
            for (IEntity iEntity2 : new HashSet<IEntity>(hashSet)) {
                hashSet.addAll(this.getDirectChildren(iEntity2));
            }
            if (hashSet.contains(iEntity) || hashSet.size() == n) {
                return Collections.unmodifiableSet(hashSet);
            }
            n = hashSet.size();
        }
    }

    private boolean hasCycle() {
        for (IEntity iEntity : this.entities) {
            if (!this.getIndirectChildren(iEntity).contains(iEntity)) continue;
            return true;
        }
        return false;
    }

    public Skeleton removeCycle() {
        Skeleton skeleton = new Skeleton();
        for (Link link : this.links) {
            skeleton.add(link);
            if (!skeleton.hasCycle()) continue;
            skeleton.links.remove(link);
        }
        return skeleton;
    }

    public void add(Link link) {
        if (this.links.contains(link)) {
            throw new IllegalArgumentException();
        }
        if (link.getEntity1().isGroup()) {
            throw new IllegalArgumentException();
        }
        if (link.getEntity2().isGroup()) {
            throw new IllegalArgumentException();
        }
        this.links.add(link);
        this.entities.add(link.getEntity1());
        this.entities.add(link.getEntity2());
    }

    public void addAll(Skeleton skeleton) {
        for (Link link : skeleton.links) {
            this.add(link);
        }
    }

    public boolean doesTouch(Link link) {
        for (Link link2 : this.links) {
            if (!link2.doesTouch(link)) continue;
            return true;
        }
        return false;
    }

    public boolean doesTouch(Skeleton skeleton) {
        for (Link link : this.links) {
            if (!skeleton.doesTouch(link)) continue;
            return true;
        }
        return false;
    }

    public void computeLayers() {
        boolean bl;
        if (this.hasCycle()) {
            throw new UnsupportedOperationException();
        }
        for (IEntity object : this.entities) {
            object.setHectorLayer(0);
        }
        do {
            bl = false;
            for (Link link : this.links) {
                if (!this.ensureLayer(link)) continue;
                bl = true;
            }
        } while (bl);
    }

    private boolean ensureLayer(Link link) {
        int n = link.getLength();
        int n2 = link.getEntity1().getHectorLayer();
        int n3 = link.getEntity2().getHectorLayer();
        if (n == 1) {
            if (n2 < n3) {
                link.getEntity1().setHectorLayer(n3);
                return true;
            }
            if (n3 < n2) {
                link.getEntity2().setHectorLayer(n2);
                return true;
            }
        } else {
            int n4 = n2 + n - 1;
            if (n3 < n4) {
                link.getEntity2().setHectorLayer(n4);
                return true;
            }
        }
        return false;
    }

    public Collection<IEntity> entities() {
        return Collections.unmodifiableCollection(this.entities);
    }
}

