/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector2.mpos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.hector2.MinMax;
import net.sourceforge.plantuml.hector2.layering.Layer;
import net.sourceforge.plantuml.hector2.mpos.MutationLayer;

public class Distribution {
    private final List<Layer> layers;

    public Distribution(List<Layer> list) {
        this.layers = new ArrayList<Layer>(list);
    }

    public Distribution mute(MutationLayer mutationLayer) {
        Distribution distribution = new Distribution(this.layers);
        int n = distribution.layers.indexOf(mutationLayer.getOriginal());
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        distribution.layers.set(n, mutationLayer.mute());
        return distribution;
    }

    public double cost(Collection<Link> collection) {
        double d = 0.0;
        for (Link link : collection) {
            d += this.getLength(link);
        }
        return d;
    }

    private double getLength(Link link) {
        IEntity iEntity = link.getEntity1();
        IEntity iEntity2 = link.getEntity2();
        int n = iEntity.getHectorLayer();
        int n2 = this.layers.get(n).getLongitude(iEntity);
        int n3 = iEntity2.getHectorLayer();
        int n4 = this.layers.get(n3).getLongitude(iEntity2);
        int n5 = n4 - n2;
        int n6 = n3 - n;
        return Math.sqrt(n5 * n5 + n6 * n6);
    }

    public List<MutationLayer> getPossibleMutations() {
        ArrayList<MutationLayer> arrayList = new ArrayList<MutationLayer>();
        for (Layer layer : this.layers) {
            arrayList.addAll(layer.getPossibleMutations());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final List<Layer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public MinMax getMinMaxLongitudes() {
        MinMax minMax = null;
        for (Layer layer : this.layers) {
            if (minMax == null) {
                minMax = layer.getMinMaxLongitudes();
                continue;
            }
            minMax = minMax.add(layer.getMinMaxLongitudes());
        }
        return minMax;
    }

    public double getNbLayers() {
        return this.layers.size();
    }
}

